var modal = (function(){                          // Zadeklarowanie obiektu modal.

  var $modal = $('<div class="modal"/>'),         // Przygotowanie kodu znaczników dla okna modalnego.
      $content = $('<div class="modal-content"/>'),
      $close = $('<button role="button" class="modal-close">zamknij</button>');
      $overlay = $('<div class="overlay"/>');     // Utworzenie elementu przykrywającego.

  $modal.append($content, $close);                // Dodanie przycisku zamykającego do okna modalnego.

  $close.click(function(e){                       // Jeżeli użytkownik kliknie przycisk zamykający okno.
    e.preventDefault();                           // Uniemożliwienie standardowego działania łącza.
    modal.close();                                // Zamknięcie okna modalnego.
  });

  return {                                         // Dodanie kodu do obiektu modal.
    center: function () {                          // Zdefiniowanie metody center().
      // Obliczenie odległości od górnej i lewej krawędzi okna, aby wyśrodkować okno modalne.
      var top = Math.max($(window).height() - $modal.outerHeight(), 0) / 2,
          left = Math.max($(window).width() - $modal.outerWidth(), 0) / 2;
      $modal.css({                                 // Style CSS dla okna modalnego.
        top:top + $(window).scrollTop(),           // Wyśrodkowanie w pionie.
        left:left + $(window).scrollLeft()         // Wyśrodkowanie w poziomie.
      });
    },
    open: function (settings) {                    // Zdefiniowanie metody open().
      $content.empty().append(settings.content);   // Zdefiniowanie nowej zawartości dla okna modalnego.

      $modal.css({                                 // Zdefiniowanie nowej zawartości dla okna modalnego.
        width: settings.width || 'auto',           // Szerokość.
        height: settings.height || 'auto'          // Wysokość.
      }).appendTo('body');                         // Umieszczenie okna modalnego na stronie.

      modal.center();                              // Wywołanie metody center().
      $(window).on('resize', modal.center);        // Wywołanie metody po zmianie wielkości okna przeglądarki internetowej.

      $('.modal').after($overlay);
    },
    close: function () {                           // Zdefiniowanie metody close().
        $content.empty();                          // Usunięcie zawartości z okna modalnego.
        $modal.detach();                           // Usunięcie okna modalnego ze strony.
        $overlay.detach();                         // Usunięcie elementu przykrywającego.
        $(window).off('resize', modal.center);     // Usunięcie procedury obsługi zdarzeń.
    }
  };
}());