package server;

import java.rmi.Naming;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.server.DefaultBankPersistenceManager;
import common.RMISSLClientSocketFactory;
import common.RMISSLServerSocketFactory;

public class RemoteBankServer {
	public static void main(String args[]) {
		try {
			DefaultBankPersistenceManager bpm =
				new DefaultBankPersistenceManager(System.getProperties());
			BankIntf bank = bpm.load();
			RemoteBankImpl rbi = new RemoteBankImpl(bank, 0,
				new RMISSLClientSocketFactory(), new RMISSLServerSocketFactory());
			Naming.rebind("MyRemoteBank", rbi);
			System.out.println("RemoteBank Server ready.");
		} catch (Exception e) {
			System.out.println("Exception: " + e.getMessage());
			e.printStackTrace();
    	}
  	}
}
