/*
 * @(#) $Id: EchoServer.java,v 1.1 2003/10/25 17:51:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net).
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the
 * root directory of the containing software.
 */
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import java.net.ServerSocket;
import java.net.Socket;

public class EchoServer {
	public static void main(String[] args) throws Exception {
		ServerSocketFactory ssf = SSLServerSocketFactory.getDefault();
		ServerSocket ss = ssf.createServerSocket(2950);

		if (args.length > 0){
			SSLServerSocket sss = (SSLServerSocket)ss;
			if ("-needClientAuth".equalsIgnoreCase(args[0])){
				sss.setNeedClientAuth(true);
			} else if ("-wantClientAuth".equalsIgnoreCase(args[0])){
				sss.setWantClientAuth(true);
			}
		}

		while (true){
			System.out.print("Waiting for connection ...");
			System.out.flush();
			Socket socket = ss.accept();
			System.out.println(" ... Connection accepted.");
			SocketUtil.printSocketInfo(socket, " <-- ");

			java.io.InputStream is = socket.getInputStream();
			java.io.OutputStream os = socket.getOutputStream();
			int nread = 0;
			byte[] buf = new byte[1024];

			while ((nread = is.read(buf)) != -1){
				System.out.println("Read " + nread + " bytes.");
				os.write(buf, 0, nread);
				System.out.println("Wrote " + nread + " bytes.");
			} // inner while
		} // while (true)
	} // main()
}
