/*
 * @(#) $Id: EchoClient.java,v 1.1 2003/10/25 17:51:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net).
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the
 * root directory of the containing software.
 */
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.SSLSocket;
import java.net.ServerSocket;
import java.net.Socket;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class EchoClient {
	public static void main(String[] args) throws Exception {
		String hostname = "localhost";
		if (args.length > 0)
			hostname = args[0];
		SocketFactory sf = SSLSocketFactory.getDefault();
		Socket socket = sf.createSocket(hostname, 2950);
		System.out.println("Connection established.");
		SocketUtil.printSocketInfo(socket, " --> ");

		java.io.InputStream is = socket.getInputStream();
		java.io.OutputStream os = socket.getOutputStream();
		byte[] buf = new byte[1024];
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

		while (true){
			System.out.print("Enter Message (Type \"quit\" to exit): ");
			System.out.flush();
			String inp = br.readLine();
			if (inp.equalsIgnoreCase("quit"))
				break;
			os.write(inp.getBytes());
			int n = is.read(buf);
			System.out.println("Server Returned: " + new String(buf, 0, n));
		} // while (true)
		socket.close();
		System.out.println("Connection closed.");
	} // main()
}
