/*
 * @(#) $Id: ComputeMAC.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import javax.crypto.Mac;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import java.io.FileInputStream;

public class ComputeMAC {
	public static void main(String[] unused) throws Exception{
		String datafile = "ComputeDigest.java";

		KeyGenerator kg = KeyGenerator.getInstance("DES");
		kg.init(56); // 56 is the keysize. Fixed for DES
		SecretKey key = kg.generateKey();

    	Mac mac = Mac.getInstance("HmacSHA1");
    	mac.init(key);

    	FileInputStream fis = new FileInputStream(datafile);
    	byte[] dataBytes = new byte[1024];
    	int nread = fis.read(dataBytes);
    	while (nread > 0) {
			mac.update(dataBytes, 0, nread);
			nread = fis.read(dataBytes);
		};
		byte[] macbytes = mac.doFinal();
		System.out.println("MAC(in hex):: " + Util.byteArray2Hex(macbytes));
	}
}