/*
 * @(#) $Id: WSSSignAndEncrypt.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.PublicKey;
import java.security.PrivateKey;
import javax.crypto.SecretKey;
import java.security.cert.X509Certificate;

import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.SigningKeyFactory;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.messaging.WSSecurity;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xpath.XPath;

public class WSSSignAndEncrypt {
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java WSSSignAndEncrypt <inp-file> [<out-file>]");
			return;
		}
		String datafile = args[0];
		String outfile = "signed_and_encrypted.xml";
		if (args.length > 1)
			outfile = args[1];

		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";
		String alias1 = "mykey";
		String alias2 = "rsakey";
		String keyfile = "3des.key";

		System.out.println("Signing XML data in file \"" + datafile + "\" using private key");
		System.out.println("in keystore \"" + keystore + "\" at alias \"" + alias1 + "\"...");
		System.out.println("And encrypting Signed data  \"" + datafile + "\" using secret key in");
		System.out.println("file \"" + keyfile + "\" and encrypting the secret key using public key");
		System.out.println("in keystore \"" + keystore + "\" at alias \"" + alias2 + "\"...");

		// Get the private key and corresponding certificate.
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());
		X509Certificate cert1 = (X509Certificate)ks.getCertificate(alias1);
		PrivateKey prvk1 = (PrivateKey)ks.getKey(alias1, storepass.toCharArray());
		X509Certificate cert2 = (X509Certificate)ks.getCertificate(alias2);
		PublicKey pubk2 = cert2.getPublicKey();

		ObjectInputStream ois = new ObjectInputStream(new FileInputStream(keyfile));
		SecretKey key = (SecretKey)ois.readObject();

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);
		SigningKey signingKey = SigningKeyFactory.makeSigningKey(prvk1);
		KeyInfo signingKeyInfo = new KeyInfo();
		signingKeyInfo.setCertificate(cert1);

		KeyInfo encryptingKeyInfo = new KeyInfo();
		encryptingKeyInfo.setCertificate(cert2);

		WSSecurity wss = new WSSecurity();
		wss.signAndEncrypt(doc,
				signingKey, signingKeyInfo,
				key, AlgorithmType.TRIPLEDES,
				pubk2, AlgorithmType.RSA1_5, encryptingKeyInfo);

		// Write the signed XML file
		XmlUtility.writeXML(doc, new FileOutputStream(outfile));
		System.out.println("... Wrote the output to file: \"" + outfile + "\"");
	}
}