/*
 * @(#) $Id: MessageBoard.java,v 1.1.1.1 2003/10/05 18:39:10 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package rmb;
import java.util.Vector;
import java.io.*;

public class MessageBoard {
	private static String RMB_SIGNATURE = "RMB 1.0";
	private Vector v = new Vector();
	private static int curidx = 0;
	private boolean loaded = false;
	private String path = "rmb.ser";
	public MessageBoard(){
	}
	public void setPath(String path){
		this.path = path;
	}
	public void load(){
		if (loaded)	// Run load() only once.
			return;
		loaded = true;
		try {
			File f = new File(path);
			if (!f.exists())
				return;
			FileInputStream fis = new FileInputStream(f);
			ObjectInputStream ois = new ObjectInputStream(fis);
			String sign = (String)ois.readObject();
			if (!sign.equals(RMB_SIGNATURE))
				return;
			curidx = ois.readInt();
			v = (Vector)ois.readObject();
			ois.close();
		} catch (Exception e){
			e.printStackTrace();
		}
	}
	public void save(){
		try {
			FileOutputStream fos = new FileOutputStream(path);
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(RMB_SIGNATURE);
			oos.writeInt(curidx);
			oos.writeObject(v);
			oos.close();
		} catch (Exception e){
			e.printStackTrace();
		}
	}
	public int size(){
		return v.size();
	}
	public MessageBean get(int index){
		return (MessageBean)v.elementAt(index);
	}

	public void add(MessageBean mb){
		v.add(mb);
	}
	public boolean remove(String msgid){
		for (int i = 0; i < v.size(); i++){
			MessageBean mb = (MessageBean)v.elementAt(i);
			if (mb.getMsgid() != null && mb.getMsgid().equals(msgid)){
				v.remove(mb);
				return true;
			}
		}
		return false;
	}
	public String nextMsgid(){
		return "msgid_" + curidx++;
	}
}