/*
 * @(#) $Id: PerfTest.java,v 1.1.1.1 2003/10/05 18:39:06 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.io.*;

public class PerfTest {
	public static int count = 1000000;
	public static String PROP = "user.dir";

	public static String getsysprop(String prop){
		return System.getProperty(prop);
	}
	public static void main(String[] args) throws IOException {
		if (args.length > 0){
			count = Integer.parseInt(args[0]);
		}
		System.out.println(PROP + " = " + getsysprop(PROP));
		String pv = null;
		for (int r = 0; r < 4; r++){	// Many rounds.
			long ts = System.currentTimeMillis();
			for (int l = 0; l < count; l++){
				pv = getsysprop(PROP);
			}
			long te = System.currentTimeMillis();
			System.out.println("Round[" + r + "], Elapsed time for " + count + " iterations: " +
				(te - ts) + " milli secs.");
		}
	}
}