/*
 * @(#) $Id: WSSClientHandler.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.wss4axis;

import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.SOAPEnvelope;
import org.w3c.dom.Document;
import java.util.Map;

public class WSSClientHandler implements Handler {
	private String keyStoreFile = null;
	private String keyStoreType = "JCEKS";
	private String keyStorePassword = "changeit";
	private String keyEntryAlias = "mykey";
	private String keyEntryPassword = null;

	private String trustStoreFile = null;
	private String trustStoreType = "JCEKS";
	private String trustStorePassword = "changeit";
	private String certEntryAlias = "mykey";

	private boolean verbose = true;

    public WSSClientHandler() {
    }

    public boolean handleRequest(MessageContext context) {
		if (verbose)
        	System.out.println("WSSClientHandler: handleRequest ...");
        if (context instanceof SOAPMessageContext){
			try {
				SOAPMessageContext soapCtx = (SOAPMessageContext)context;
				SOAPMessage soapMsg = soapCtx.getMessage();
				Document doc = SOAPUtility.toDocument(soapMsg);

				WSSUtility.sign(doc, keyStoreFile, keyStoreType,
						keyStorePassword, keyEntryAlias, keyEntryPassword);
				WSSUtility.encrypt(doc, trustStoreFile, trustStoreType,
						trustStorePassword, certEntryAlias);

				soapMsg = SOAPUtility.toSOAPMessage(doc);
				soapCtx.setMessage(soapMsg);
			} catch (Exception e){
				System.err.println("WSClientHandler::handleRequest -- Exception: " + e);
			}
		}
		if (verbose)
			System.out.println("WSSClientHandler: ... handleRequest");
        return true;
    }

    public boolean handleResponse(MessageContext context) {
		if (verbose)
        	System.out.println("WSSClientHandler: handleResponse ...");
        if (context instanceof SOAPMessageContext){
			try {
				SOAPMessageContext soapCtx = (SOAPMessageContext)context;
				SOAPMessage soapMsg = soapCtx.getMessage();
				Document doc = SOAPUtility.toDocument(soapMsg);

				WSSUtility.decrypt(doc, keyStoreFile, keyStoreType,
						keyStorePassword, keyEntryAlias, keyEntryPassword);
				WSSUtility.verify(doc, trustStoreFile, trustStoreType, trustStorePassword);
				WSSUtility.cleanup(doc);

				soapMsg = SOAPUtility.toSOAPMessage(doc);
				soapCtx.setMessage(soapMsg);
			} catch (Exception e){
				System.err.println("WSClientHandler::handleResponse -- Exception: " + e);
			}
		}
		if (verbose)
			System.out.println("... WSSClientHandler: handleResponse");
        return true;
    }

    public boolean handleFault(MessageContext context) {
        System.out.println("WSSClientHandler: In handleFault");
        return true;
    }

    public void init(HandlerInfo config) {
		System.out.println("WSSClientHandler: init ...");
		Object o = null;
		Map configProps = config.getHandlerConfig();
		String verboseStr = (String)configProps.get("verbose");
		if (verboseStr != null && verboseStr.equalsIgnoreCase("false"))
			verbose = false;

		keyStoreFile = (String)configProps.get("keyStoreFile");
		if ((o = configProps.get("keyStoreType")) != null)
			keyStoreType = (String)o;
		if ((o = configProps.get("keyStorePassword")) != null)
			keyStorePassword = (String)o;
		if ((o = configProps.get("keyEntryAlias")) != null)
			keyEntryAlias = (String)o;
		if ((o = configProps.get("keyEntryPassword")) != null)
			keyEntryPassword = (String)o;
		else
			keyEntryPassword = keyStorePassword;

		if (verbose){
			System.out.println("WSSClientHandler:: keyStoreFile = " + keyStoreFile);
			System.out.println("WSSClientHandler:: keyStoreType = " + keyStoreType);
			System.out.println("WSSClientHandler:: keyStorePassword = " + keyStorePassword);
			System.out.println("WSSClientHandler:: keyEntryAlias = " + keyEntryAlias);
			System.out.println("WSSClientHandler:: keyEntryPassword = " + keyEntryPassword);
		}

		trustStoreFile = (String)configProps.get("trustStoreFile");
		if ((o = configProps.get("trustStoreType")) != null)
			trustStoreType = (String)o;
		if ((o = configProps.get("trustStorePassword")) != null)
			trustStorePassword = (String)o;
		if ((o = configProps.get("certEntryAlias")) != null)
			certEntryAlias = (String)o;

		if (verbose){
			System.out.println("WSSClientHandler:: trustStoreFile = " + trustStoreFile);
			System.out.println("WSSClientHandler:: trustStoreType = " + trustStoreType);
			System.out.println("WSSClientHandler:: trustStorePassword = " + trustStorePassword);
			System.out.println("WSSClientHandler:: certEntryAlias = " + certEntryAlias);

			System.out.println("WSSClientHandler: ... init");
		}
    }

    public void destroy() {
    }

    public javax.xml.namespace.QName[] getHeaders() {
        return null;
    }
}
