/*
 * @(#) $Id: WSSecurityExtn.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import org.w3c.dom.Document;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.DOMCursor;
import com.verisign.messaging.XmlMessageException;
import com.verisign.util.Namespaces;

public class WSSecurityExtn {
    private static final String WSSE_URI =
	    "http://schemas.xmlsoap.org/ws/2002/07/secext";
    private static final String WSSE_PREFIX = "wsse";
    private static final String WSU_URI =
	    "http://schemas.xmlsoap.org/ws/2002/07/utility";
    private static final String WSU_PREFIX = "wsu";
    private static final String SOAP_URI = Namespaces.SOAPENV.getUri();
    private static final String SOAP_PREFIX = Namespaces.SOAPENV.getPrefix();
    private static final String XMLSIG_URI = Namespaces.XMLSIG.getUri();
    private static final String XMLSIG_PREFIX = Namespaces.XMLSIG.getPrefix();
    private static final String XMLENC_URI = Namespaces.XMLENC.getUri();
    private static final String XMLENC_PREFIX = Namespaces.XMLENC.getPrefix();
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private static final String SOAP_FAULT = "Fault";
    private static final boolean USE_WSU_FOR_SECURITY_TOKEN_ID = false;

    public static void removeWSSEncryptedKey(Document message) throws XmlMessageException {
        DOMWriteCursor c = new DOMWriteCursor(message);
        checkEnvelope(c);

        // Remove EncryptedKey elem. from WS-Security Header Element
        if (c.moveToChild(SOAP_URI, SOAP_HEADER)) {
			if (c.moveToChild(WSSE_URI, "Security")) {
				if (c.moveToChild(XMLENC_URI, "EncryptedKey")) {
					c.remove();
				}
			}
        }
	}

    public static void removeWSSInfo(Document message) throws XmlMessageException {
        DOMWriteCursor c = new DOMWriteCursor(message);
        checkEnvelope(c);

        // Remove WS-Security Header Element
        if (c.moveToChild(SOAP_URI, SOAP_HEADER)) {
			if (c.moveToChild(WSSE_URI, "Security")) {
				c.remove();
			}
        }

        // Remove Timestamp Header Element
        c.moveToTop();
        if (c.moveToChild(SOAP_URI, SOAP_HEADER)) {
			if (c.moveToChild(WSU_URI, "Timestamp")) {
				c.remove();
			}
		}

		// Remove wsu:Id attribute from Body Element
		c.moveToTop();
		if (c.moveToChild(SOAP_URI, SOAP_BODY)) {
			c.setAttribute(WSU_URI, WSU_PREFIX, "Id", null);
		}
	}

    private static void checkEnvelope(DOMCursor c) throws XmlMessageException {
        c.moveToTop();
        if (!c.atElement(SOAP_URI, SOAP_ENVELOPE)) {
            throw new XmlMessageException("Missing SOAP envelope");
        }
    }
}