/*
 * @(#) $Id: EchoClient1.java,v 1.1.1.1 2003/10/05 18:39:02 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;

import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Service;
import javax.xml.rpc.Call;

public class EchoClient1 {
    public static void main(String [] args) throws Exception {
		String epAddr = "http://localhost:8080/axis/services/StringEchoPort1";

        String wsdlAddr = "file:echo.wsdl";
        String nameSpaceUri = "http://www.pankaj-k.net/jsbook/examples/";
        String svcName = "StringEchoService1";
        String portName = "StringEchoPort1";

        java.net.URL wsdlUrl = new java.net.URL(wsdlAddr);
        ServiceFactory svcFactory = ServiceFactory.newInstance();
        QName svcQName = new QName(nameSpaceUri, svcName);
        Service svc = svcFactory.createService(wsdlUrl, svcQName);

		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Enter Username: ");
        System.out.flush();
        String username = br.readLine();
        System.out.print("Enter Password: ");
        System.out.flush();
        String password = br.readLine();

        Call call = (Call) svc.createCall();

        call.setTargetEndpointAddress(epAddr);
        call.setOperationName( new QName(nameSpaceUri, "echo") );
        call.setPortTypeName( new QName(nameSpaceUri, portName) );

        call.setProperty(Call.USERNAME_PROPERTY, username);
        call.setProperty(Call.PASSWORD_PROPERTY, password);

		Object arg = "Hi, How are you?";
		System.out.println("sending: " + arg );
        String res = (String) call.invoke(new Object[] {arg});
        System.out.println("received: " + res );
    }
}
