/*
 * @(#) $Id: Client2.java,v 1.1.1.1 2003/10/05 18:38:59 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class Client2 {
	public static void main(String[] args) throws Exception {
		String url = null;
		String uname = null;
		String passwd = null;
		if (args.length > 2){
			url = args[0];
			uname = args[1];
			passwd = args[2];
		} else {
			System.out.println("Usage:: java client.Client <url> <uname> <passwd>");
			System.exit(0);
		}

		LoginContext loginContext = new LoginContext("Sample",
			new SampleCallbackHandler(uname, passwd, url));
		loginContext.login();
		Subject subject = loginContext.getSubject();
		SampleAction sampleAction = new SampleAction(url);
		Subject.doAs(subject, sampleAction);
	}
}
