@echo off
rem check for env. variable JAVA_HOME

set _JAVA_BIN=%JAVA_HOME%\bin
if "%_JAVA_BIN%" == "\bin" goto jdkNotFound

set _JSTK_HOME=%JSTK_HOME%
if "%_JSTK_HOME%" == "" goto search

if exist "%_JSTK_HOME%\license.jstk" goto start
echo File license.jstk not found in JSTK_HOME directory: %JSTK_HOME%
goto eof

:search
rem try the current dir. and the parent dir., in that order, for JSTK_HOME
set _JSTK_HOME=.
if exist "%_JSTK_HOME%\license.jstk" goto start

set _JSTK_HOME=..
if exist "%_JSTK_HOME%\license.jstk" goto start

echo Unable to determine the home directory for JSTK. Set JSTK_HOME to the proper value.
goto eof

:start
set _CP=

for %%i in (%_JSTK_HOME%\lib\*.jar) do call %_JSTK_HOME%\bin\cpappend %%i
for %%i in (%_JSTK_HOME%\build\*.jar) do call %_JSTK_HOME%\bin\cpappend %%i

set _SERVER_CLASS=org.jstk.jstksh.JSTKShellRMIServerImpl
set _DEFS=
if "%JSTKSH_AUTH_FLAG%" == "" goto run

set _DEFS=-Djava.security.manager -Djava.security.policy=config\jstksh-auth.policy -Djstk.home=%_JSTK_HOME%
set _DEFS=%_DEFS% -Djava.security.auth.login.config=config\login.conf
set _SERVER_CLASS=org.jstk.jstksh.JSTKShellAuthRMIServerImpl

:run
%JAVA_HOME%\bin\java %_DEFS% %JSTK_OPTS% -cp %_CP% %_SERVER_CLASS% %*
goto eof

:classNotFound
echo No class specified.
goto eof

:jdkNotFound
echo You must have JAVA_HOME set to your JDK Installation directory.

:eof
set _JSTK_HOME=
set _JAVA_BIN=
set _CP=
