@echo off
setlocal
rem check for env. variable JAVA_HOME

set _JAVA_BIN=%JAVA_HOME%\bin
if "%_JAVA_BIN%" == "\bin" goto jdkNotFound

set _JSTK_HOME=%JSTK_HOME%
if "%_JSTK_HOME%" == "" goto search

if exist "%_JSTK_HOME%\license.jstk" goto start
echo File license.jstk not found in JSTK_HOME directory: %JSTK_HOME%
goto eof

:search
rem try the current dir. and the parent dir., in that order, for JSTK_HOME
set _JSTK_HOME=.
if exist "%_JSTK_HOME%\license.jstk" goto start

set _JSTK_HOME=..
if exist "%_JSTK_HOME%\license.jstk" goto start

echo Unable to determine the home directory for JSTK. Set JSTK_HOME to the proper value.
goto eof

:start
set _CP=

for %%i in (%_JSTK_HOME%\lib\*.jar) do call %_JSTK_HOME%\bin\cpappend %%i
for %%i in (%_JSTK_HOME%\build\*.jar) do call %_JSTK_HOME%\bin\cpappend %%i

set _JSTKSH_LOGIN=
set _DEFS=
if "%JSTKSH_SM_FLAG%" == "" goto checkAuthFlag
if "%JSTKSH_POLICY_FILE%" == "" set JSTKSH_POLICY_FILE=config\jstksh-sa.policy
set _DEFS=%_DEFS% -Djava.security.manager
rem set _DEFS=%_DEFS% -Djava.security.debug=all
set _DEFS=%_DEFS% -Djava.security.policy=%JSTKSH_POLICY_FILE%
set _DEFS=%_DEFS% -Djstk.home=%_JSTK_HOME%
goto run

:checkAuthFlag
if "%JSTKSH_AUTH_FLAG%" == "" goto run
if "%JSTKSH_POLICY_FILE%" == "" set JSTKSH_POLICY_FILE=config\jstksh-auth.policy
set _DEFS=%_DEFS% -Djava.security.manager
rem set _DEFS=%_DEFS% -Djava.security.debug=policy
set _DEFS=%_DEFS% -Djava.security.policy=%JSTKSH_POLICY_FILE%
rem set _DEFS=%_DEFS% -Djava.security.auth.policy=config\policy.jaas
if "%JSTKSH_LOGIN_CONF%" == "" set JSTKSH_LOGIN_CONF=config\login.conf
set _DEFS=%_DEFS% -Djava.security.auth.login.config=%JSTKSH_LOGIN_CONF%
set _DEFS=%_DEFS% -Djstk.home=%_JSTK_HOME%
set _JSTKSH_LOGIN=-login

:run
echo _DEFS = %_DEFS%
%JAVA_HOME%\bin\java %JSTK_OPTS% %_DEFS% -cp %_CP% org.jstk.jstksh.JSTKShellClient %_JSTKSH_LOGIN% %*
goto eof

:classNotFound
echo No class specified.
goto eof

:jdkNotFound
echo You must have JAVA_HOME set to your JDK Installation directory.

:eof
set _JSTK_HOME=
set _JAVA_BIN=
set _CP=
