package server;

import java.rmi.Naming;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.server.DefaultBankPersistenceManager;

public class RemoteBankServer {
	public static void main(String args[]) {
		try {
			DefaultBankPersistenceManager bpm =
				new DefaultBankPersistenceManager(System.getProperties());
			BankIntf bank = bpm.load();
			//RemoteBankImpl rbi = new RemoteBankImpl(bank);
			RemoteLoginServerImpl rlsi = new RemoteLoginServerImpl(bank);
			Naming.rebind("MyRemoteLoginServer", rlsi);
			System.out.println("RemoteBank Server with LoginServer ready.");
		} catch (Exception e) {
			System.out.println("Exception: " + e.getMessage());
			e.printStackTrace();
    	}
  	}
}
