package client;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Iterator;
import common.RemoteIterator;
import common.RemoteAccount;

public class IteratorProxy implements Iterator {
	private RemoteIterator ri;
	public IteratorProxy(RemoteIterator ri){
		this.ri = ri;
	}
	public boolean hasNext(){
		try {
			return ri.hasNext();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public Object next(){
		try {
			return new AccountProxy((RemoteAccount)ri.next());
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public void remove(){
		try {
			ri.remove();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
}
