/*
 * @(#) $Id: Encrypt1.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.KeyPair;
import java.security.PublicKey;
import javax.crypto.SecretKey;

import com.verisign.xmlenc.Encryptor;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xpath.XPath;

public class Encrypt1 {
	public static void main(String[] args) throws Exception {
		// Input to encryption.
		String datafile = "book.xml";
		String encfile = "enc.xml";
		XPath encloc = new XPath("id('book_info')");
		System.out.println("Encrypting element with id=book_info of file \"" + datafile + "\"");

		// Info to get Secret Key and Key Pair.
		String kpfile = "rsa.kp";
		String keyfile = "3des.key";
		System.out.println("Using RSA key-pair in file \"" + kpfile + "\" ...");

		// Get the secret key and key pair from file.
		FileInputStream fis = new FileInputStream(kpfile);
		ObjectInputStream ois = new ObjectInputStream(fis);
		KeyPair kp = (KeyPair)ois.readObject();
		PublicKey pk = kp.getPublic();
		fis = new FileInputStream(keyfile);
		ois = new ObjectInputStream(fis);
		SecretKey key = (SecretKey)ois.readObject();

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);

		Encryptor encryptor = new Encryptor(doc,
			key, AlgorithmType.TRIPLEDES, pk, AlgorithmType.RSA1_5);
		Document encryptedDoc = encryptor.encrypt(encloc);

		// Write the signed XML file
		XmlUtility.writeXML(encryptedDoc, new FileOutputStream(encfile));

		System.out.println();
		System.out.println("Encryption SUCCESSFUL!!");
		System.out.println("Document with encrypted element written to file: " + encfile);
	}
}