/*
 * @(#) $Id: CreateSignature.java,v 1.1.1.1 2003/10/05 18:39:07 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import com.verisign.xmlsig.Signer;
import com.verisign.xpath.XPath;

public class CreateSignature {
	public static void main(String[] args) throws Exception {
		// Input to signature.
		String datafile = "book.xml";
		String sigfile = "sig.xml";
		XPath tobeSigned1 = new XPath("id('book_info')");
		XPath tobeSigned2 = new XPath("id('book_title')");
		XPath sigloc = new XPath("id('book_title')");
		System.out.println("Signing two elements of file \"" + datafile + "\"");

		// Info to get Signing Key.
		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";
		String alias = "mykey";
		System.out.println("Using private key in keystore \"" + keystore + "\" ...");

		// Get the private key and corresponding certificate.
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());
		PrivateKey key = (PrivateKey)ks.getKey(alias, storepass.toCharArray());
		X509Certificate cert = (X509Certificate)ks.getCertificate(alias);

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);

		Signer signer = new Signer(doc, key, cert);
		signer.addReference(tobeSigned1);
		signer.addReference(tobeSigned2);

		// signer.useExclusiveCanonicalizer(java.util.Collections.EMPTY_LIST);
		Document signedDoc = signer.sign(sigloc, true);

		// Write the signed XML file
		XmlUtility.writeXML(signedDoc, new FileOutputStream(sigfile));

		System.out.println();
		System.out.println("Signature Creation SUCCESSFUL!!");
		System.out.println("Signature written to file: " + sigfile);
	}
}