/*
 * @(#) $Id: SocketUtil.java,v 1.1 2003/10/25 17:51:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net).
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the
 * root directory of the containing software.
 */
import java.net.Socket;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLPeerUnverifiedException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class SocketUtil {
	public static void printSocketInfo(Socket socket, String dir) {
		try {
			InetSocketAddress localAddr = (InetSocketAddress)socket.getLocalSocketAddress();
			InetSocketAddress remoteAddr = (InetSocketAddress)socket.getRemoteSocketAddress();
			String localAddrId = localAddr.getHostName() + ":" + localAddr.getPort();
			String remoteAddrId = remoteAddr.getHostName() + ":" + remoteAddr.getPort();

			System.out.println("  Connection   : " + localAddrId + dir + remoteAddrId);
			if (socket instanceof SSLSocket){
				SSLSession sess = ((SSLSocket)socket).getSession();
				System.out.println("  Protocol     : " + sess.getProtocol());
				System.out.println("  Cipher Suite : " + sess.getCipherSuite());
				Certificate[] localCerts = sess.getLocalCertificates();
				if (localCerts != null && localCerts.length > 0)
					printCertDNs(localCerts, "  Local Certs : ");

				Certificate[] remoteCerts = null;
				try {
					remoteCerts = sess.getPeerCertificates();
					printCertDNs(remoteCerts, "  Remote Certs: ");
				} catch (SSLPeerUnverifiedException exc){
					System.out.println("  Remote Certs: Unverified");
				}
			} else {
				System.out.println("  Protocol     : TCP");
			}
		} catch (Exception exc){
			System.err.println("Could not print Socket Information: " + exc);
		}
	}

	private static void printCertDNs(Certificate[] certs, String label){
		System.out.println(label + "[0]" + ((X509Certificate)certs[0]).getSubjectDN());
		StringBuffer indent = new StringBuffer();
		for (int i = label.length(); i > 0; i--)
			indent.append(" ");
		for (int i = 1; i < certs.length; i++){
			System.out.println(indent.toString() + "[" + i + "]" +
				((X509Certificate)certs[i]).getSubjectDN());
		}
	}
}
