/*
 * @(#) $Id: ShowCipherSuites.java,v 1.1 2003/10/25 17:51:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net).
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the
 * root directory of the containing software.
 */
import javax.net.ssl.SSLSocketFactory;

public class ShowCipherSuites {
	public static void main(String[] args) {
		SSLSocketFactory ssf = (SSLSocketFactory) SSLSocketFactory.getDefault();
		String[] supportedCSuites = ssf.getSupportedCipherSuites();
		String[] enabledCSuites = ssf.getDefaultCipherSuites();

		System.out.println("Supported Cipher Suites:");
		for (int i = 0; i < supportedCSuites.length; i++){
			System.out.println("\t[" + i + "] " + supportedCSuites[i]);
		}
		System.out.println();
		System.out.println("Enabled Cipher Suites  :");
		for (int i = 0; i < enabledCSuites.length; i++){
			System.out.println("\t[" + i + "] " + enabledCSuites[i]);
		}
	}
}
