/*
 * @(#) $Id: ShowCertPath.java,v 1.1.1.1 2003/10/05 18:39:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.util.Iterator;
import java.util.List;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedInputStream;

public class ShowCertPath{
	public static void printCertPath(CertPath cp){
		List list = cp.getCertificates();
		Iterator li = list.iterator();
		System.out.println("CertPath:");
		int index = 0;
		while (li.hasNext()){
			System.out.println("CertPath Component: " + index );
			X509Certificate cert = (X509Certificate)li.next();
			ShowCert.printX509Cert(cert, "  ");
			++index;
		}
	}

	public static void main(String[] args) throws Exception{
		if (args.length < 1){
			System.out.println("Usage:: java ShowCertPath <certpathfile>");
			return;
		}
		String certpathfile = args[0];
		CertificateFactory cf = CertificateFactory.getInstance("X.509");
		FileInputStream fis = new FileInputStream(certpathfile);

		File file = new File(certpathfile);
		int bufsize = (int)file.length() + 1024; // Added 1024 for extra safety.
		BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), bufsize);
		bis.mark(bufsize);

		CertPath cp = null;
		try {
			cp = cf.generateCertPath(bis, "PkiPath");
		} catch (CertificateException ce) {
			bis.reset();
			try {
				cp = cf.generateCertPath(bis, "PKCS7");
			} catch (CertificateException cei) {
				System.out.println("CertPath format not recognized.");
				return;
			}
		}
		printCertPath(cp);
	}
}