/*
 * @(#) $Id: GenerateSecretKey.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import java.security.Key;

public class GenerateSecretKey {
	private static String formatKey(Key key){
		StringBuffer sb = new StringBuffer();
		String algo = key.getAlgorithm();
		String fmt = key.getFormat();
		byte[] encoded = key.getEncoded();
		sb.append("Key[algorithm=" + algo + ", format=" + fmt + ", bytes=" + encoded.length + "]\n");
		if (fmt.equalsIgnoreCase("RAW")){
			sb.append("Key Material (in hex):: ");
			sb.append(Util.byteArray2Hex(key.getEncoded()));
		}
		return sb.toString();
	}
	public static void main(String[] unused) throws Exception {
		KeyGenerator kg = KeyGenerator.getInstance("DES");
		kg.init(56); // 56 is the keysize. Fixed for DES
		SecretKey key = kg.generateKey();
		System.out.println("Generated Key:: " + formatKey(key));
	}
}