/*
 * @(#) $Id: WSSDecrypt.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.VerifyingKeyFactory;
import com.verisign.messaging.WSSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.xpath.XPath;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;

public class WSSDecrypt {
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java WSSDecrypt <inp-file> [<out-file>]");
			return;
		}
		String datafile = args[0];
		String outfile = "decrypted.xml";
		if (args.length > 1)
			outfile = args[1];

		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";
		String alias2 = "rsakey";

		System.out.println("Decrypting SOAP data in file \"" + datafile + "\" using private key");
		System.out.println("in keystore \"" + keystore + "\" at alias " + alias2 + " ...");

		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());
		PrivateKey prvk2 = (PrivateKey)ks.getKey(alias2, storepass.toCharArray());

		Document doc = XmlUtility.readXML(datafile);

		WSSecurity wss = new WSSecurity();
		wss.decrypt(doc, prvk2, null);
		WSSecurityExtn.removeWSSInfo(doc);

		XmlUtility.writeXML(doc, new FileOutputStream(outfile));
	}
}