/*
 * @(#) $Id: Client.java,v 1.1.1.1 2003/10/05 18:38:59 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import javax.naming.Context;
import echo.EchoHome;
import echo.Echo;

public class Client {
	private static String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
	//private static String JNDI_FACTORY = "com.sun.jndi.cosnaming.CNCtxFactory";
	public static void main(String[] args) throws Exception {
		int count = 1;
		if (args.length < 1){
			System.out.println("Usage:: java client.Client <url>");
			return;
		}
		String url = args[0];
		if (args.length > 1){
			count = Integer.parseInt(args[1]);
		}

		java.util.Properties h = new java.util.Properties();
		h.put(Context.INITIAL_CONTEXT_FACTORY, JNDI_FACTORY);

		h.put(Context.PROVIDER_URL, url);
		Context ctx = new javax.naming.InitialContext(h);

		Object home = ctx.lookup("ex1-echo-EchoHome");
		EchoHome ehome = (EchoHome)narrow(home, EchoHome.class);
		Echo estub = (Echo)narrow(ehome.create(), Echo.class);

		String msg = "Hello, World!!";
		System.out.println("Calling Echo.echo(\"" + msg + "\") ...");
		String resp = null;
		long ts = System.currentTimeMillis();
		for (int i = 0; i < count; ++i){
			resp = estub.echo(msg);
		}
		long et = System.currentTimeMillis() - ts;
		System.out.println("... Echo.echo(\"" + msg + "\") = " + resp);

		if (count > 1){
			System.out.println("Elapsed Time for " + count + " invocations: " + et + " Milli Secs.");
		}

		System.out.println("Echo Client Executed successfully.");
	}

	private static Object narrow(Object o, Class c){
		return javax.rmi.PortableRemoteObject.narrow(o, c);
	}
}
