package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.jstk.example.bank.BankIntf;
import common.RemoteBank;
import common.RemoteLoginServer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class RemoteLoginServerImpl extends UnicastRemoteObject implements RemoteLoginServer {
	private BankIntf bi;
	public RemoteLoginServerImpl(BankIntf bi) throws RemoteException {
		this.bi = bi;
	}
	public RemoteBank login(String username, String password) throws LoginException, RemoteException {
		LoginContext lc = new LoginContext("Bank", new RemoteCallbackHandler(username, password));
		lc.login();
		return new RemoteBankImpl(bi, lc.getSubject());
	}
}

class RemoteCallbackHandler implements CallbackHandler {
	private String username;
	private String password;
	RemoteCallbackHandler(String username, String password){
		this.username = username;
		this.password = password;
	}
	public void handle(Callback[] cb) {
    	for (int i = 0; i < cb.length; i++){
			if (cb[i] instanceof NameCallback){
				NameCallback nc = (NameCallback)cb[i];
				nc.setName(username);
			} else if (cb[i] instanceof PasswordCallback){
				PasswordCallback pc = (PasswordCallback)cb[i];
				pc.setPassword(password.toCharArray());
				password = null;
			}
		}
	}
}