/*
 * @(#) $Id: AccountProxy.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.AccountIntf;
import common.RemoteAccount;

public class AccountProxy implements AccountIntf {
	private RemoteAccount racct = null;

	public AccountProxy(RemoteAccount racct){
		this.racct = racct;
	}
	public void deposit(BigDecimal amt) throws Exceptions.AccountClosed {
		try {
			racct.deposit(amt);
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public void withdraw(BigDecimal amt) throws Exceptions.AccountClosed,
			Exceptions.InsufficientAmount {
		try {
		racct.withdraw(amt);
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public void close() throws Exceptions.AccountClosed {
		try {
		racct.close();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public BigDecimal getBalance() throws Exceptions.AccountClosed {
		try {
		return racct.getBalance();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public String getAcctNo(){
		try {
		return racct.getAcctNo();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public String getStatement(){
		try {
		return racct.getStatement();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
}
