/*
 * @(#) $Id: Decrypt1.java,v 1.1.1.1 2003/10/05 18:39:07 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.KeyPair;
import java.security.PrivateKey;

import com.verisign.xmlenc.Decryptor;
import com.verisign.xpath.XPath;

public class Decrypt1 {
	public static void main(String[] args) throws Exception {
		// Input to signature.
		String encfile = "enc.xml";
		String decfile = "dec.xml";
		System.out.println("Decrypting file \"" + decfile + "\"");

		// Info to get Secret Key.
		String kpfile = "rsa.kp";
		System.out.println("Using secret key in file \"" + kpfile + "\" ...");

		// Get the secret key from file.
		FileInputStream fis = new FileInputStream(kpfile);
		ObjectInputStream ois = new ObjectInputStream(fis);
		KeyPair kp = (KeyPair)ois.readObject();
		PrivateKey pk = kp.getPrivate();

		// Read the XML file
		Document doc = XmlUtility.readXML(encfile);

		String[] ns = {"xenc", "http://www.w3.org/2001/04/xmlenc#"};
 		XPath encloc = new XPath("//xenc:EncryptedData", ns);

		Decryptor decryptor = new Decryptor(doc, pk, encloc);
		Document decryptedDoc = decryptor.decrypt();

		// Write the signed XML file
		XmlUtility.writeXML(decryptedDoc, new FileOutputStream(decfile));

		System.out.println();
		System.out.println("Decryption SUCCESSFUL!!");
		System.out.println("Decrypted document written to file: " + decfile);
	}
}