/*
 * @(#) $Id: Canonicalize.java,v 1.1.1.1 2003/10/05 18:39:07 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import org.w3c.dom.Document;

import com.verisign.c14n.*;
import com.verisign.domutil.*;
import com.verisign.xpath.*;

public class Canonicalize {
	private static String NORMAL_C14N = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
	private static String NORMAL_C14NWC = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
	private static String EXC_C14N = "http://www.w3.org/2001/10/xml-exc-c14n#";
	private static String EXC_C14NWC = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
	public static void main(String[] args) throws Exception {
		// Input to signature.
		String datafile = "../../../../data/book.xml";

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);
		Canonicalizer c = CanonicalizerFactory.getInstance(NORMAL_C14N);
		byte[] ba = c.canonicalize(doc);
		System.out.println("Output of Normal Canonicalization:");
		System.out.write(ba);
		System.out.println();


		Canonicalizer c1 = CanonicalizerFactory.getInstance(NORMAL_C14N);
		DOMCursor dc1 = new DOMCursor(doc);
		dc1.moveToXPath(new XPath("id('book_title')"));
		byte[] ba1 = c1.canonicalize(dc1.getElement());
		System.out.println("Output of Normal Canonicalization:");
		System.out.write(ba1);
		System.out.println();

		Canonicalizer c2 = CanonicalizerFactory.getInstance(EXC_C14N);
		DOMCursor dc2 = new DOMCursor(doc);
		dc2.moveToXPath(new XPath("id('book_title')"));
		byte[] ba2 = c2.canonicalize(dc2.getElement());
		System.out.println("Output of Exclusive Canonicalization:");
		System.out.write(ba2);
		System.out.println();
	}
}