/*
 * @(#) $Id: AsymmetricCipherTest.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.security.KeyPairGenerator;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.BadPaddingException;
import java.security.SignatureException;
import java.security.NoSuchAlgorithmException;
import java.security.InvalidKeyException;
import java.security.InvalidAlgorithmParameterException;

public class AsymmetricCipherTest {
	private static byte[] encrypt(byte[] inpBytes, PublicKey key, String xform) throws
			NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException,
			NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
   		Cipher cipher = Cipher.getInstance(xform);
   		cipher.init(Cipher.ENCRYPT_MODE, key);
   		return cipher.doFinal(inpBytes);
	}
	private static byte[] decrypt(byte[] inpBytes, PrivateKey key, String xform) throws
			NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException,
			NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException{
   		Cipher cipher = Cipher.getInstance(xform);
   		cipher.init(Cipher.DECRYPT_MODE, key);
   		return cipher.doFinal(inpBytes);
	}

	public static void main(String[] unused) throws Exception {
		String xform = "RSA/NONE/PKCS1PADDING";
		int keysize = 56;
		// Generate a key-pair
		KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
		kpg.initialize(512); // 512 is the keysize.
		KeyPair kp = kpg.generateKeyPair();
		PublicKey pubk = kp.getPublic();
		PrivateKey prvk = kp.getPrivate();

		byte[] dataBytes = "J2EE Security for Servlets, EJBs and Web Services".getBytes();

		byte[] encBytes = encrypt(dataBytes, pubk, xform);
		byte[] decBytes = decrypt(encBytes, prvk, xform);

		boolean expected = java.util.Arrays.equals(dataBytes, decBytes);
		System.out.println("Test " + (expected ? "SUCCEEDED!" : "FAILED!"));
	}
}