/*
 * @(#) $Id: Client.java,v 1.1.1.1 2003/10/05 18:39:00 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import echo.*;
import gw.*;

public class Client {

	private static final String JNDI_ECHO_NAME = "ex3-echo-EchoHome";
	private static final String JNDI_ECHOGW_NAME = "ex3-gw-EchoGWHome";

	public static void main(String[] args) throws Exception {
		String url = null;
		String method = null;
		String uname = null;
		String passwd = null;
		if (args.length > 3){
			url = args[0];
			method = args[1];
			uname = args[2];
			passwd = args[3];
		} else if (args.length > 1){
			url = args[0];
			method = args[1];
		} else {
			System.out.println("Usage:: java client.Client <url> <method> <uname> <passwd>");
			System.exit(0);
		}

		Properties h = new Properties();

		//h.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.cosnaming.CNCtxFactory");
		h.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");

		h.put(Context.PROVIDER_URL, url);
		if (uname != null && passwd != null){
			h.put(Context.SECURITY_PRINCIPAL, uname);
			h.put(Context.SECURITY_CREDENTIALS, passwd);
		}

		Context ctx = new InitialContext(h);
		String msg = "Hello, World!!";
		String resp = null;

		if (method.equals("gwEcho")){
			Object home = ctx.lookup(JNDI_ECHOGW_NAME);
			EchoGWHome ghome = (EchoGWHome) PortableRemoteObject.narrow(home, EchoGWHome.class);
			EchoGW gstub = (EchoGW) PortableRemoteObject.narrow(ghome.create(), EchoGW.class);

			System.out.println("Calling gstub.gwEcho(\"" + msg + "\")...");
			resp = gstub.gwEcho(msg);
		} else if (method.equals("echo") || method.equals("echo2") || method.equals("echo3") ||
					method.equals("echo4")){
			Object home = ctx.lookup(JNDI_ECHO_NAME);
			EchoHome ehome = (EchoHome) PortableRemoteObject.narrow(home, EchoHome.class);
			Echo estub = (Echo) PortableRemoteObject.narrow(ehome.create(), Echo.class);

			System.out.println("Calling estub." + method + "(\"" + msg + "\")...");
			if (method.equals("echo")){
				resp = estub.echo(msg);
			} else 	if (method.equals("echo2")){
				resp = estub.echo2(msg);
			} else if (method.equals("echo3")){
				resp = estub.echo3(msg);
			} else if (method.equals("echo4")){
				resp = estub.echo4(msg);
			}
		} else {
			System.out.println("No such method:: " + method);
			return;
		}
		System.out.println("Returned String: " + resp);
		System.out.println("... Client Executed successfully.");
	}

	private static Object narrow(Object o, Class cls){
		return PortableRemoteObject.narrow(o, cls);
	}
}
