import java.net.*;
import java.io.*;
import java.util.*;
import javax.net.*;
import javax.net.ssl.*;
import javax.swing.*;

/** Wewntrzny klient proxy uywany przez WebClient. dania proxy
 *  s wysyane w nastpujcym formacie:<P>
 *
 *  GET URL HTTP/1.0
 *
 *  <P>gdzie URL oznacza URL programu WebClient, na przykad
 *  http://www.google.com/.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class HttpProxyClient extends HttpClient {
  private URL proxyURL;

  public HttpProxyClient(URL url,
                         URL proxyURL,
                         String requestMethod,
                         String httpVersion,
                         List requestHeaders,
                         String queryData,
                         JTextArea outputArea) {
    super(url, requestMethod, httpVersion,
          requestHeaders, queryData, outputArea);
    this.proxyURL = proxyURL;
  }

  /** Otwarcie poczenia TCP do komputera proxy. */

  public void connect() {
    if(!isValidURL() || !isValidProxyURL()) {
      return;
    }
    String host = proxyURL.getHost();
    int port = proxyURL.getPort();
    if (port == -1) {
      port = proxyURL.getDefaultPort();
    }
    connect(host, port);
  }

  /** Utworzenie wiersza dania HTTP do serwera proxy. Zamiast wskazania
   *  URI, danie GET lub POST wskazuje peen URL
   *  dania oryginalnej strony. Na przykad <P>
   *
   *  GET http://www.google.com/  HTTP/1.0
   */

  protected String getRequestLine() {
    String method = "GET";
    String url = this.url.toString();
    String version = "HTTP/1.0";
    // Sprawdzenie, czy metod HTTP jest POST. Jeli nie, jest to danie GET.
    // Dodanie do dania GET danych zapytania po znaku ?.
    if ("POST".equalsIgnoreCase(requestMethod)) {
      method = "POST";
    } else {
      if (queryData.length() > 0) {
        url += "?" + queryData;
      }
    }
    if ("HTTP/1.1".equalsIgnoreCase(httpVersion)) {
      version = "HTTP/1.1";
    }
    String request = method + " " + url + " " + version;
    return(request);
  }

  /** Sprawdzenie, czy serwer proxy jest prawidowym adresem komputera. */

  protected boolean isValidProxyURL() {
    if (proxyURL == null) {
      return(false);
    }
    try {
      InetAddress.getByName(proxyURL.getHost());
      return(true);
    } catch(UnknownHostException uhe) {
      report("Bogus Proxy: " + url.getHost());
      return(false);
    }
  }
}