
import System;
import System.IO;



class objectDisposedException extends System.ApplicationException {
	function objectDisposedException() { }
	function objectDisposedException(s:String) {
		super(s);
	}
	function objectDisposedException(s:String,e:Exception) {
		super(s,e);
	}
	
}

class sampleTempFile extends Object {

	var theFile :String ;
	var isDisposed : Boolean;
	
	function sampleTempFile() {
		theFile = Path.GetTempFileName();
		isDisposed=false;
	}
	
	function get fileName() : String {
		return theFile;
	}
	function Write(s:String) {
		if (isDisposed) throw new objectDisposedException();
		Console.WriteLine("Wywoanie Write({0})",s);
	}
	
	function Read() : String {
		if (isDisposed) throw new objectDisposedException();
		return "Wywoanie Read()";
	}
   function Dispose() {
      Console.WriteLine("Wywoanie Dispose()");
      Dispose(true);
      isDisposed=true;
   }

   function Close() {
      Console.WriteLine("Wywoanie Close()");
      this.Dispose();
   }

   protected function Finalize() {
		isDisposed=true;
      Console.WriteLine("Wywoanie Finalize()");
      Dispose(true);
   }

   private function Dispose( disposing: Boolean ) {
      Console.WriteLine("Wywoanie Dispose(" + disposing.ToString() + ")");

	  try { 
		if (disposing) { 
			Console.WriteLine("Dispose: Teraz usuwamy obiekty");
		}
	  }	
	  catch(e:Exception) {
	     
	     // przechwytujemy wszystko...nic nie robimy
	  }
	  finally {

		// Jeeli trzeba, usuwamy obiekt bazowy...
		// super.Dispose(disposing);

		// poniewa obiekt this zosta usunity, nie ma potrzeby, aby GC
		// wywoywa metod Finalize. Nastpna instrukcja nakazuje 
		// pomin Finalize()...
		GC.SuppressFinalize(this);
		Console.WriteLine("Dispose: zakoczone");		
      }
   }

}


var tempFile : sampleTempFile = new sampleTempFile();

Console.WriteLine("Nazwa pliku tymczasowego to: {0}",tempFile.fileName);
tempFile.Write("Test1");
Console.WriteLine(tempFile.Read());
//tempFile.Close();




/** Dane wyjciowe...
Przy pierwszej prbie wiersz tempFile.Close() jest wyczony (jako komentarz). GC (mechanizm odmiecania) wywoa metod Finalize wraz z zakoczeniem programu.

Nazwa pliku tymczasowego to: f:\tmp\tmpBA.tmp
Wywoanie Write(Test1)
Wywoanie Read()
Wywoanie Finalize()          <-************
Wywoanie Dispose(True)
Dispose: Teraz usuwamy obiekty
Dispose: zakoczone

W drugiej prbie wiersz tempFile.Close() zosta zachowany. W tym przypadku GC nie wywoa metody Finalize(), poniewa Dispose() poinformowaa, e nie jest to konieczne, bo usuna ju zasoby wywoaniem Close().

Nazwa pliku tymczasowego to: f:\tmp\tmpB4.tmp
Wywoanie Write(Test1)
Wywoanie Read()
Wywoanie Close()
Wywoanie Dispose()
Wywoanie Dispose(True)
Dispose: Teraz usuwamy obiekty
Dispose: zakoczone
**/
