package various;

import javax.faces.component.html.HtmlCommandButton;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;



	/**
	 * Przyklad ilustrujacy obsuge zdarzenia akcji
	 *  dla przycisku typu HtmlCommandButton  po fazie aktualizacji modelu danych, 
	 *  a nie jak w przypadku standardowych przyciskw po fazie wywoania metod aplikacji
	 *  (patrz rozdzial 4.1).
	 */
	public class QuickHtmlCommandButton extends HtmlCommandButton {
		public void queueEvent(FacesEvent event) {
			if (event instanceof ActionEvent) {
				if (isImmediate()) {
					event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
				} else {
					event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
				}
			}
			super.queueEvent(event);
		}
	}


