package isrp.hibernate.model.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.SessionFactory;

public class HibernateUtil {
	private static final SessionFactory sessionFactory;
	private static Log logger = LogFactory.getLog(HibernateUtil.class);
    static {
        try {
            // Tworzy obiekt SessionFactory  (na podstawie hibernate.cfg.xml)
            sessionFactory = new AnnotationConfiguration().configure().buildSessionFactory();
        } catch (Throwable ex) {
            // Log the exception. 
            logger.error("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);            
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }
}
