package various;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.model.SelectItem;

/**Kod zrodlowy do przykladu z rozdzialu 5.5 (podpowiadanie w richfaces).
 *
 */
public class CapitalsBB {
	private ArrayList<Capital> capitals = new ArrayList<Capital>();
	private ArrayList<String> capitalsNames = new ArrayList<String>();
	private List<SelectItem> capitalsOptions = new ArrayList<SelectItem>();
	private String capital = "";

	public class Capital {
		String name = "";
		String country = "";

		Capital() {
		};

		Capital(String name, String country) {
			this.name = name;
			this.country = country;
		};

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getCountry() {
			return country;
		}

		public void setCountry(String country) {
			this.country = country;
		}

	}

	/**
	 * @param suggest 
	 * @return
	 */
	public List<Capital> autocomplete(Object suggest) {
		String pref = (String) suggest;
		ArrayList<Capital> result = new ArrayList<Capital>();

		Iterator<Capital> iterator = capitals.iterator();
		while (iterator.hasNext()) {
			Capital elem = ((Capital) iterator.next());
			if ((elem.getName() != null && elem.getName().toLowerCase()
					.indexOf(pref.toLowerCase()) == 0)
					|| "".equals(pref)) {
				result.add(elem);
			}
		}
		return result;
	}

	public CapitalsBB() {
		capitals.clear();
		capitals.add(new Capital("Pary", "Francja"));
		capitals.add(new Capital("Wiede", "Austria"));
		capitals.add(new Capital("Tokio", "Japonia"));
		capitals.add(new Capital("Warszawa", "Polska"));
		capitalsNames.clear();
		for (Capital cap : capitals) {
			capitalsNames.add(cap.getName());
		}
		capitalsOptions.clear();
		for (Capital cap : capitals) {
			capitalsOptions
					.add(new SelectItem(cap.getName(), cap.getCountry()));
		}
	}

	
	public String getCapital() {
		return capital;
	}

	public void setCapital(String capital) {
		this.capital = capital;
	}

	public List<SelectItem> getCapitalsOptions() {
		return capitalsOptions;
	}

	public ArrayList<String> getCapitalsNames() {
		return capitalsNames;
	}

}
