package isrp.hibernate.model.dao;

import isrp.hibernate.model.businessobject.Review;

import java.util.List;

import org.hibernate.criterion.Restrictions;

public class ReviewDao extends GenericDao {

	public ReviewDao() {
		super(Review.class);
	}

	@SuppressWarnings("unchecked")
	public List<Review> getReviewerReviews(int reviewerId) {
		return (List<Review>) session.createCriteria(persistedClass).add(
				Restrictions.eq("reviewerId", reviewerId)).list();
	}

	public Review findByPaperId(Integer paperId) {
		return (Review) session.createCriteria(persistedClass).add(
				Restrictions.eq("paperId", paperId)).uniqueResult();
	}

}
