package isrp.viewbeans;

import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.Review;
import isrp.hibernate.model.businessobject.User;

import java.io.Serializable;
import java.util.Locale;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

/**
 * Komponent wsparcia dla przechowania sesji uytkownika.
 *
 */
public class VisitBean implements Serializable{	
	private static final long serialVersionUID = 1L;
	//login user
	private User user;
	private AuthenticationBean authenticationBean;
	private Paper currentPaper;
	//for registration, adding, editing
	private User currentUser;	
	private Review currentReview;
	
	public void changeLocale(ActionEvent event) {
		FacesContext context=FacesContext.getCurrentInstance();	
		String language = context.getExternalContext()
			.getRequestParameterMap().get("locale");
		if (language!=null)
			context.getViewRoot().setLocale(new Locale(language));
	}


	public Review getCurrentReview() {
		if (currentReview==null){
			currentReview = new Review();
		}
		return currentReview;
	}
	public void setCurrentReview(Review currentReview) {
		this.currentReview = currentReview;
	}
	public User getCurrentUser() {		
		if (currentUser==null){
			currentUser = new User();			
		}
		return currentUser;
	}
	public void setCurrentUser(User currentUser) {
		this.currentUser = currentUser;
	}
	public User getUser() {
		return user;
	}
	public void setUser(User user) {
		this.user = user;
	}
	public AuthenticationBean getAuthenticationBean() {
		return authenticationBean;
	}
	public void setAuthenticationBean(AuthenticationBean authenticationBean) {
		this.authenticationBean = authenticationBean;
	}
	public Paper getCurrentPaper() {
		if (currentPaper==null){
			currentPaper = new Paper();
		}
		return currentPaper;
	}
	public void setCurrentPaper(Paper currentPaper) {
		this.currentPaper = currentPaper;
	}
	
	

}
