package isrp.viewbeans;

import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.Review;
import isrp.hibernate.model.businessobject.User;
import isrp.hibernate.model.dao.ReviewDao;
import isrp.hibernate.model.dao.factory.DaoFactory;
import isrp.model.service.PaperService;
import isrp.model.service.UserService;
import isrp.utils.MessageUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.ListDataModel;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

/**Komponent wsparcia dla zarzadzania lista prac.
 *
 */
public class PapersListBean implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private ListDataModel papersList;
	private VisitBean visitBean;
	private String sortColumn;
	private UtilBean utilBean;

	
	public PapersListBean() {
		//sprawdzenie czy utilBean nie jest nullem
		FacesContext ctx = FacesContext.getCurrentInstance();
		if (utilBean == null) utilBean=(UtilBean)ctx.getApplication().evaluateExpressionGet(ctx, "#{utilBean}", UtilBean.class);
	}

	public String toAddNewVersionPage() {
		Paper paper = (Paper) papersList.getRowData();
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		}
		visitBean.setCurrentPaper(paper);
		return "add_new_version";
	}

	public String approvePaper() {
		Paper paper = (Paper) papersList.getRowData();
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		}
		paper.setStatus(new Byte("3"));
		paperSer.approvePaper(paper,utilBean.getEmailConfiguration());
		papersList=null;
		return "all_papers_list";
	}

	public String rejectPaper() {
		Paper paper = (Paper) papersList.getRowData();
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		}
		paper.setStatus(new Byte("4"));
		paperSer.rejectPaper(paper,utilBean.getEmailConfiguration());
		papersList=null;
		return "all_papers_list";
	}

	public String toReviewDetailsPage() {
		Paper paper = (Paper) papersList.getRowData();
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		ReviewDao rDao = DaoFactory.getInstance().getReviewDao();
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		} else {
			visitBean.setCurrentReview(rDao.findByPaperId(paper.getId()));
			return "review_details_page";
		}
	}

	public String toReviewPaper() {
		Paper paper = (Paper) papersList.getRowData();
		// making sure that paper stil exist
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		} else {
			visitBean.setCurrentPaper(paper);
			visitBean.setCurrentReview(new Review());
			return "review_paper_page";
		}
	}

	public String toAssignReviewerPage() {
		UserService uSer = utilBean.getServiceLocator().getUserService();
		List<User> revList = uSer.getReviewers(); 
		if (revList.size()==0){
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),"reviewer.notExists");
			return null;
		}
		Paper paper = (Paper) papersList.getRowData();
		visitBean.setCurrentPaper(paper);
		return "assign_reviewer";
	}

	public String deletePaper() {
		Paper paper = (Paper) papersList.getRowData();
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		} else {
			paperSer.delete(paper);
		}
		papersList=null;
		return "all_papers_list";		
	}

	public String toPaperDetailsPage() {
		Paper paper = (Paper) papersList.getRowData();
		// making sure that paper stil exist
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		} else {
			visitBean.setCurrentPaper(paper);
			return "paper_details_page";
		}
	}

	public String toEditPaperPage() {
		Paper paper = (Paper) papersList.getRowData();
		// making sure that paper stil exist
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paper = paperSer.findById(paper.getId());
		if (paper == null) {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.message.notExists");
			return null;
		} else {
			visitBean.setCurrentPaper(paper);
			return "edit_paper_page";
		}
	}

	public void sort(ActionEvent actionEvent) {
		// actionEvent.getComponent().getId()
		String id = actionEvent.getComponent().getId();
		if (id.equals("title")) {
			sortColumn = "title";
		} else if (id.equals("authors")) {
			sortColumn = "authors";
		} else if (id.equals("status")) {
			sortColumn = "status";
		}
		papersList = null;
	}

	public void download(ActionEvent event) {
		HttpServletResponse response = (HttpServletResponse) FacesContext
				.getCurrentInstance().getExternalContext().getResponse();
		String pathFile = utilBean.getUploadPath();
		String downloadFile = visitBean.getCurrentPaper().getPath();
		String title = visitBean.getCurrentPaper().getTitle();
		String fileExtension = downloadFile.substring(downloadFile
				.lastIndexOf('.'));
		response.setContentType("application/force-download");
		response.addHeader("Content-Disposition", "attachment; filename=\""
				+ title + fileExtension + "\"");
		byte[] buf = new byte[1024];
		try {
			File file = new File(pathFile + "/" + downloadFile);
			long length = file.length();
			BufferedInputStream in = new BufferedInputStream(
					new FileInputStream(file));
			ServletOutputStream out = response.getOutputStream();
			response.setContentLength((int) length);
			while ((in != null) && ((length = in.read(buf)) != -1)) {
				out.write(buf, 0, (int) length);
			}
			in.close();
			out.close();
		} catch (Exception exc) {
			exc.printStackTrace();
		}
		// bez poniszej linii do pliku zostanie dogenerowana zawartosc strony
		// (postback)
		FacesContext.getCurrentInstance().responseComplete();
	}

	public String getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(String sortColumn) {
		this.sortColumn = sortColumn;
	}

	public ListDataModel getPapersList() {
		if (papersList == null) {
			PaperService paperSer = utilBean.getServiceLocator()
					.getPaperService();
			List<Paper> papers = paperSer.getAllPapers(sortColumn, visitBean.getUser().getId(), new Integer(visitBean.getUser().getRole()));
			if (papers.size()>0){
				papersList = new ListDataModel(papers);				
			}else{
				//jesli lista prac jest pusta
				papersList = null;
			}
		}
		return papersList;
	}

	public void setPapersList(ListDataModel papersList) {
		this.papersList = papersList;
	}

	public VisitBean getVisitBean() {
		return visitBean;
	}

	public void setVisitBean(VisitBean visitBean) {
		this.visitBean = visitBean;
	}

	public void setUtilBean(UtilBean utilBean) {
		this.utilBean = utilBean;
	}

	public UtilBean getUtilBean() {
		return utilBean;
	}

}
