package isrp.model.service;

import java.util.List;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.User;
import isrp.hibernate.model.util.email.EmailConfiguration;

public interface PaperService {

	boolean addPaperNewVersion(Paper paper, User author,
			UploadedFile uploadedFile, String uploadPath,
			EmailConfiguration emailConfiguration);

	void update(Paper paper);

	void assignReviewer(Paper paper, int reviewerId,
			EmailConfiguration emailConfiguration);

	boolean addPaper(Paper paper, User author, UploadedFile uploadedFile,
			String uploadPath, EmailConfiguration emailConfiguration);

	Paper findById(int id);

	void delete(Paper paper);

	void approvePaper(Paper paper, EmailConfiguration emailConfiguration);

	void rejectPaper(Paper paper, EmailConfiguration emailConfiguration);

	List<Paper> getReviewerPapers(int reviewerId, String sortColumn);

	List<Paper> getAuthorPapers(int userId, String sortColumn);

	List<Paper> getAllPapers(String sortColumn);

	List<Paper> getAllPapers(String sortColumn, Integer userId, Integer role);
}
