package isrp.viewbeans;

import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.User;
import isrp.model.service.PaperService;
import isrp.model.service.UserService;
import isrp.utils.IsrpUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/**
 * Komponent wsparcia dla przypisania recenzenta do pracy.
 *
 */
public class AssignReviewerBean implements Serializable {

	private static final long serialVersionUID = 1L;
	private VisitBean visitBean;
	private ArrayList<SelectItem> reviewersArray;
	private Integer reviewerId;
	private UtilBean utilBean;
	
	public String assignReviewer(){
		Paper paper = visitBean.getCurrentPaper();
		paper.setReviewerId(reviewerId);
		//przypisanie recenzenta
		paper.setStatus(new Byte("1"));
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		paperSer.assignReviewer(paper,reviewerId,utilBean.getEmailConfiguration());		
		//musimy wymusi odwieenie papersListBean
		PapersListBean pBean = (PapersListBean) IsrpUtils.getBean(FacesContext.getCurrentInstance(), "sessionScope","papersListBean");
		pBean.setPapersList(null);
		
		return "all_papers_list";
	}
	
	public VisitBean getVisitBean() {
		return visitBean;
	}
	public void setVisitBean(VisitBean visitBean) {
		this.visitBean = visitBean;
	}
	public ArrayList<SelectItem> getReviewersArray() {
		UserService uSer = utilBean.getServiceLocator().getUserService();
		List<User> revList = uSer.getReviewers(); 
		reviewersArray = new ArrayList<SelectItem>();		
		for (int i=0;i<revList.size();i++){			
			reviewersArray.add(new SelectItem(revList.get(i).getId(),revList.get(i).getFirstName()+" "+revList.get(i).getLastName() ));
		}
		return reviewersArray;
	}
	public void setReviewersArray(ArrayList<SelectItem> reviewersArray) {
		this.reviewersArray = reviewersArray;
	}
	public Integer getReviewerId() {
		return reviewerId;
	}
	public void setReviewerId(Integer reviewerId) {
		this.reviewerId = reviewerId;
	}

	public void setUtilBean(UtilBean utilBean) {
		this.utilBean = utilBean;
	}

	public UtilBean getUtilBean() {
		return utilBean;
	}

}
