/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.deploy.shared.factories;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

public final class DeploymentFactoryManager {
    private static DeploymentFactoryManager instance = new DeploymentFactoryManager();
    private List deploymentFactories = new ArrayList();

    private DeploymentFactoryManager() {
    }

    public static DeploymentFactoryManager getInstance() {
        return instance;
    }

    public DeploymentFactory[] getDeploymentFactories() {
        return this.deploymentFactories.toArray(new DeploymentFactory[this.deploymentFactories.size()]);
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (uri == null) {
            throw new IllegalArgumentException("URI for DeploymentManager should not be null");
        }
        DeploymentManager manager = null;
        for (DeploymentFactory factory : this.deploymentFactories) {
            if (!factory.handlesURI(uri) || (manager = factory.getDeploymentManager(uri, username, password)) == null) continue;
            return manager;
        }
        throw new DeploymentManagerCreationException("No registered DeploymentFactory can handles this URI");
    }

    public void registerDeploymentFactory(DeploymentFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("DeploymentFactory to register should not be null");
        }
        if (!this.deploymentFactories.contains(factory)) {
            this.deploymentFactories.add(factory);
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (uri == null) {
            throw new IllegalArgumentException("URI for DeploymentManager should not be null");
        }
        DeploymentManager manager = null;
        for (DeploymentFactory factory : this.deploymentFactories) {
            if (!factory.handlesURI(uri) || (manager = factory.getDisconnectedDeploymentManager(uri)) == null) continue;
            return manager;
        }
        throw new DeploymentManagerCreationException("No registered DeploymentFactory can handles this URI");
    }
}

