/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.scripting.ActionListenerProxy;
import com.sun.faces.scripting.ELResolverProxy;
import com.sun.faces.scripting.NavigationHandlerProxy;
import com.sun.faces.scripting.PhaseListenerProxy;
import com.sun.faces.scripting.RendererProxy;
import com.sun.faces.scripting.ViewHandlerProxy;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELResolver;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.render.Renderer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigProcessor
implements ConfigProcessor {
    private ConfigProcessor nextProcessor;

    @Override
    public void setNext(ConfigProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void invokeNext(Document[] documents) throws Exception {
        if (this.nextProcessor != null) {
            this.nextProcessor.process(documents);
        }
    }

    protected Application getApplication() {
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }

    protected String getNodeText(Node node) {
        String res = null;
        if (node != null && (res = node.getTextContent()) != null) {
            res = res.trim();
        }
        return res != null && res.length() != 0 ? res : null;
    }

    protected Map<String, String> getTextMap(List<Node> list) {
        if (list != null && !list.isEmpty()) {
            int len = list.size();
            HashMap<String, String> names = new HashMap<String, String>(len, 1.0f);
            for (int i = 0; i < len; ++i) {
                Node node = list.get(i);
                String textValue = this.getNodeText(node);
                if (textValue == null) continue;
                if (node.hasAttributes()) {
                    NamedNodeMap attributes = node.getAttributes();
                    String lang = this.getNodeText(attributes.getNamedItem("lang"));
                    if (lang == null) {
                        lang = this.getNodeText(attributes.getNamedItem("xml:lang"));
                    }
                    if (lang != null) {
                        names.put(lang, textValue);
                        continue;
                    }
                    names.put("DEFAULT", textValue);
                    continue;
                }
                names.put("DEFAULT", textValue);
            }
            return names;
        }
        return null;
    }

    protected Object createInstance(String className, Node source) {
        return this.createInstance(className, null, null, source);
    }

    protected Object createInstance(String className, Class rootType, Object root, Node source) {
        Object returnObject = null;
        if (className != null) {
            try {
                Class<?> clazz = this.loadClass(className, returnObject, rootType);
                if (clazz != null) {
                    Constructor construct;
                    Class<?>[] interfaces;
                    if (this.isDevModeEnabled() && (interfaces = clazz.getInterfaces()) != null) {
                        for (Class<?> c : interfaces) {
                            if (!"groovy.lang.GroovyObject".equals(c.getName())) continue;
                            returnObject = this.createScriptProxy(rootType, className, root);
                            break;
                        }
                    }
                    if (returnObject == null && rootType != null && root != null && (construct = ReflectionUtils.lookupConstructor(clazz, rootType)) != null) {
                        returnObject = construct.newInstance(root);
                    }
                    if (clazz != null && returnObject == null) {
                        returnObject = clazz.newInstance();
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", className), source));
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", className, ncdfe.toString()), source));
            }
            catch (ClassCastException cce) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", className, rootType), source));
            }
            catch (Exception e) {
                throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", className, e.toString()), source), e);
            }
        }
        return returnObject;
    }

    protected Class<?> loadClass(String className, Object fallback, Class<?> expectedType) throws ClassNotFoundException {
        Class clazz = Util.loadClass(className, fallback);
        if (expectedType != null && !expectedType.isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        return clazz;
    }

    private String buildMessage(String cause, Node source) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", source.getOwnerDocument().getDocumentURI(), cause);
    }

    private Object createScriptProxy(Class<?> artifactType, String scriptName, Object root) {
        if (Renderer.class.equals(artifactType)) {
            return new RendererProxy(scriptName);
        }
        if (PhaseListener.class.equals(artifactType)) {
            return new PhaseListenerProxy(scriptName);
        }
        if (ViewHandler.class.equals(artifactType)) {
            return new ViewHandlerProxy(scriptName, (ViewHandler)root);
        }
        if (NavigationHandler.class.equals(artifactType)) {
            return new NavigationHandlerProxy(scriptName, (NavigationHandler)root);
        }
        if (ActionListener.class.equals(artifactType)) {
            return new ActionListenerProxy(scriptName, (ActionListener)root);
        }
        if (ELResolver.class.equals(artifactType)) {
            return new ELResolverProxy(scriptName);
        }
        return null;
    }

    private boolean isDevModeEnabled() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        return webconfig != null && webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DevelopmentMode);
    }
}

