/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.taglib;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.html.HtmlComponentHandler;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.custom.tree.HtmlTree;
import org.apache.myfaces.custom.tree.model.DefaultTreeModel;
import org.apache.myfaces.custom.tree.model.TreeModel;
import org.apache.myfaces.custom.tree.model.TreePath;

public class TreeTagHandler
extends HtmlComponentHandler {
    private TagAttribute valueAttr = this.getRequiredAttribute("value");
    private TagAttribute expandRootAttr = this.getRequiredAttribute("expandRoot");
    private boolean expandRoot = false;

    public TreeTagHandler(ComponentConfig config) {
        super(config);
    }

    protected void setAttributes(FaceletContext ctx, Object instance) {
        super.setAttributes(ctx, instance);
        Application app = ctx.getFacesContext().getApplication();
        HtmlTree tree = (HtmlTree)instance;
        if (this.valueAttr != null) {
            String value = this.valueAttr.getValue();
            if (value != null && UIComponentTag.isValueReference((String)value)) {
                tree.setValueBinding("model", app.createValueBinding(this.valueAttr.getValue()));
            }
        } else {
            ValueBinding binding = tree.getValueBinding("model");
            if (binding == null) {
                binding = app.createValueBinding("#{sessionScope.tree}");
            }
            tree.setValueBinding("model", binding);
        }
        if (this.expandRootAttr != null) {
            this.expandRoot = this.expandRootAttr.getBoolean(ctx);
        }
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent component, UIComponent parent) {
        TreeModel model;
        ValueBinding valueBinding;
        TreeModel treeModel;
        String value;
        FacesContext context = ctx.getFacesContext();
        Application app = ctx.getFacesContext().getApplication();
        if (this.valueAttr != null && (value = this.valueAttr.getValue()) != null && (treeModel = (TreeModel)(valueBinding = app.createValueBinding(value)).getValue(context)) == null) {
            treeModel = new DefaultTreeModel();
            valueBinding.setValue(context, (Object)treeModel);
        }
        HtmlTree tree = (HtmlTree)component;
        if (this.expandRoot && (model = tree.getModel(context)) != null) {
            tree.expandPath(new TreePath(new Object[]{model.getRoot()}), context);
        }
        tree.addToModelListeners();
    }
}

