/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.bind.DatatypeConverter;

public final class Utils {
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 10240;
    private static final String PATTERN_RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final String ERROR_UNSUPPORTED_ENCODING = "UTF-8 is apparently not supported on this machine.";
    public static final Comparator<Comparable> NULL_COMPARATOR = new NullComparator();

    private Utils() {
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return value.toString() == null || value.toString().isEmpty();
    }

    public static boolean isBlank(String string) {
        return Utils.isEmpty(string) || string.trim().isEmpty();
    }

    public static boolean isNumber(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDecimal(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!(object == null ? other == null : object.equals(other))) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithOneOf(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long stream(InputStream input, OutputStream output) throws IOException {
        long l;
        ReadableByteChannel inputChannel = null;
        WritableByteChannel outputChannel = null;
        try {
            inputChannel = Channels.newChannel(input);
            outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
            long size = 0L;
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                size += (long)outputChannel.write(buffer);
                buffer.clear();
            }
            l = size;
        }
        catch (Throwable throwable) {
            Utils.close(outputChannel);
            Utils.close(inputChannel);
            throw throwable;
        }
        Utils.close(outputChannel);
        Utils.close(inputChannel);
        return l;
    }

    public static IOException close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                return e;
            }
        }
        return null;
    }

    public static <T> Set<T> unmodifiableSet(Object ... values) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object value : values) {
            if (value instanceof Object[]) {
                for (Object item : (Object[])value) {
                    set.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    set.add(item);
                }
                continue;
            }
            set.add(value);
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        ArrayList<T> list = null;
        if (iterable instanceof List) {
            list = (ArrayList<T>)iterable;
        } else if (iterable instanceof Collection) {
            list = new ArrayList((Collection)iterable);
        } else {
            list = new ArrayList<T>();
            Iterator<T> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }

    public static List<String> csvToList(String values) {
        return Utils.csvToList(values, ",");
    }

    public static List<String> csvToList(String values, String delimiter) {
        if (Utils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values.split(Pattern.quote(delimiter))) {
            String trimmedValue = value.trim();
            if (Utils.isEmpty(trimmedValue)) continue;
            list.add(trimmedValue);
        }
        return list;
    }

    public static <T> Map<T, T> reverse(Map<T, T> source) {
        HashMap<T, T> target = new HashMap<T, T>();
        for (Map.Entry<T, T> entry : source.entrySet()) {
            target.put(entry.getValue(), entry.getKey());
        }
        return target;
    }

    public static boolean containsByClassName(Collection<?> objects, String className) {
        for (Object object : objects) {
            if (!object.getClass().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> TreeSet<T> nullSafeTreeSet(Collection<T> collection) {
        TreeSet<Comparable> nullSafeTreeSet = new TreeSet<Comparable>(NULL_COMPARATOR);
        nullSafeTreeSet.addAll(collection);
        return nullSafeTreeSet;
    }

    public static String formatRFC1123(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        sdf.setTimeZone(TIMEZONE_GMT);
        return sdf.format(date);
    }

    public static Date parseRFC1123(String string) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        return sdf.parse(string);
    }

    public static String serializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayInputStream raw = new ByteArrayInputStream(string.getBytes("UTF-8"));
            ByteArrayOutputStream deflated = new ByteArrayOutputStream();
            Utils.stream(raw, new DeflaterOutputStream((OutputStream)deflated, new Deflater(9)));
            String base64 = DatatypeConverter.printBase64Binary((byte[])deflated.toByteArray());
            return base64.replace('/', '~').replace('+', '-').replace('=', '_');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unserializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            String base64 = string.replace('~', '/').replace('-', '+').replace('_', '=');
            ByteArrayInputStream deflated = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)base64));
            ByteArrayOutputStream raw = new ByteArrayOutputStream();
            Utils.stream(new InflaterInputStream(deflated), raw);
            return new String(raw.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e);
        }
    }

    public static String decodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e);
        }
    }

    public static String escapeJS(String string, boolean escapeSingleQuote) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(string.length());
        block13: for (char c : string.toCharArray()) {
            if (c > '\u0fff') {
                builder.append("\\u" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                builder.append("\\u0" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                builder.append("\\u00" + Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        builder.append('\\').append('b');
                        break;
                    }
                    case '\n': {
                        builder.append('\\').append('n');
                        break;
                    }
                    case '\t': {
                        builder.append('\\').append('t');
                        break;
                    }
                    case '\f': {
                        builder.append('\\').append('f');
                        break;
                    }
                    case '\r': {
                        builder.append('\\').append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            builder.append("\\u00" + Integer.toHexString(c));
                            break;
                        }
                        builder.append("\\u000" + Integer.toHexString(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    if (escapeSingleQuote) {
                        builder.append('\\');
                    }
                    builder.append('\'');
                    continue block13;
                }
                case '\"': {
                    builder.append('\\').append('\"');
                    continue block13;
                }
                case '\\': {
                    builder.append('\\').append('\\');
                    continue block13;
                }
                case '/': {
                    builder.append('\\').append('/');
                    continue block13;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    private static class NullComparator
    implements Comparator<Comparable>,
    Serializable {
        private static final long serialVersionUID = 304919481351409790L;

        private NullComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1 == null ? 1 : (o2 == null ? -1 : o1.compareTo(o2));
        }
    }
}

