/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.omnifaces.servlet.HttpServletResponseOutputWrapper;

public class GzipHttpServletResponse
extends HttpServletResponseOutputWrapper {
    private static final Pattern NO_TRANSFORM = Pattern.compile("((.*)[\\s,])?no-transform([\\s,](.*))?", 2);
    private int threshold;
    private Set<String> mimetypes;
    private int contentLength;
    private String vary;
    private boolean noGzip;
    private boolean closing;
    private GzipThresholdOutputStream output;

    public GzipHttpServletResponse(HttpServletResponse wrapped, int threshold, Set<String> mimetypes) {
        super(wrapped);
        this.threshold = threshold;
        this.mimetypes = mimetypes;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        if (name != null) {
            if ("vary".equals(name = name.toLowerCase())) {
                this.vary = value;
            } else if ("content-range".equals(name)) {
                this.noGzip = value != null;
            } else if ("cache-control".equals(name)) {
                this.noGzip = value != null && NO_TRANSFORM.matcher(value).matches();
            }
        }
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        if (name != null && value != null) {
            if ("vary".equals(name = name.toLowerCase())) {
                this.vary = (this.vary != null ? this.vary + "," : "") + value;
            } else if ("content-range".equals(name)) {
                this.noGzip = true;
            } else if ("cache-control".equals(name)) {
                this.noGzip = this.noGzip || NO_TRANSFORM.matcher(value).matches();
            }
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.isCommitted()) {
            super.flushBuffer();
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (!this.isCommitted()) {
            this.contentLength = 0;
            this.vary = null;
            this.noGzip = false;
            if (this.output != null) {
                this.output.reset();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        super.close();
        this.closing = false;
    }

    @Override
    protected OutputStream createOutputStream() {
        this.output = new GzipThresholdOutputStream(this.threshold);
        return this.output;
    }

    private class GzipThresholdOutputStream
    extends OutputStream {
        private static final String ERROR_CLOSED = "Stream is already closed.";
        private byte[] thresholdBuffer;
        private int thresholdLength;
        private OutputStream output;
        private boolean closed;

        public GzipThresholdOutputStream(int threshold) {
            this.thresholdBuffer = new byte[threshold];
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            this.checkClosed();
            if (length == 0) {
                return;
            }
            if (this.output == null) {
                if (length - offset <= this.thresholdBuffer.length - this.thresholdLength) {
                    System.arraycopy(bytes, offset, this.thresholdBuffer, this.thresholdLength, length);
                    this.thresholdLength += length;
                    return;
                }
                this.output = this.createGzipOutputStreamIfNecessary(true);
                this.output.write(this.thresholdBuffer, 0, this.thresholdLength);
            }
            this.output.write(bytes, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.checkClosed();
            if (this.output != null) {
                this.output.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.output == null) {
                GzipHttpServletResponse.this.setContentLength(this.thresholdLength);
                this.output = this.createGzipOutputStreamIfNecessary(false);
                this.output.write(this.thresholdBuffer, 0, this.thresholdLength);
            }
            this.output.close();
            this.closed = true;
        }

        public void reset() {
            this.thresholdLength = 0;
            this.output = null;
        }

        private OutputStream createGzipOutputStreamIfNecessary(boolean gzip) throws IOException {
            String contentType;
            ServletResponse originalResponse = GzipHttpServletResponse.this.getResponse();
            if (gzip && !GzipHttpServletResponse.this.noGzip && (GzipHttpServletResponse.this.closing || !GzipHttpServletResponse.this.isCommitted()) && (contentType = GzipHttpServletResponse.this.getContentType()) != null && GzipHttpServletResponse.this.mimetypes.contains(contentType.split(";", 2)[0])) {
                GzipHttpServletResponse.this.addHeader("Content-Encoding", "gzip");
                GzipHttpServletResponse.this.setHeader("Vary", (GzipHttpServletResponse.this.vary != null && !GzipHttpServletResponse.this.vary.equals("*") ? GzipHttpServletResponse.this.vary + "," : "") + "Accept-Encoding");
                return new GZIPOutputStream((OutputStream)originalResponse.getOutputStream());
            }
            if (GzipHttpServletResponse.this.contentLength > 0) {
                originalResponse.setContentLength(GzipHttpServletResponse.this.contentLength);
            }
            return originalResponse.getOutputStream();
        }

        private void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException(ERROR_CLOSED);
            }
        }
    }
}

