/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public class UnmappedResourceHandler
extends ResourceHandlerWrapper {
    private ResourceHandler wrapped;

    public UnmappedResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        final Resource resource = super.createResource(resourceName, libraryName, contentType);
        if (resource == null) {
            return null;
        }
        return new ResourceWrapper(){

            public String getRequestPath() {
                String path = super.getRequestPath();
                String mapping = Faces.getMapping();
                if (Faces.isPrefixMapping(mapping)) {
                    return path.replaceFirst(mapping, "");
                }
                if (path.contains("?")) {
                    return path.replace(mapping + "?", "?");
                }
                return path.substring(0, path.length() - mapping.length());
            }

            public String getResourceName() {
                return this.getWrapped().getResourceName();
            }

            public String getLibraryName() {
                return this.getWrapped().getLibraryName();
            }

            public String getContentType() {
                return this.getWrapped().getContentType();
            }

            public Resource getWrapped() {
                return resource;
            }
        };
    }

    public boolean isResourceRequest(FacesContext context) {
        return "/javax.faces.resource".equals(context.getExternalContext().getRequestServletPath());
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        String resourceName = externalContext.getRequestPathInfo();
        String libraryName = (String)externalContext.getRequestParameterMap().get("ln");
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName != null ? resourceName.substring(1) : null, libraryName);
        if (resource == null) {
            super.handleResourceRequest(context);
            return;
        }
        if (!resource.userAgentNeedsUpdate(context)) {
            externalContext.setResponseStatus(304);
            return;
        }
        externalContext.setResponseContentType(resource.getContentType());
        for (Map.Entry header : resource.getResponseHeaders().entrySet()) {
            externalContext.setResponseHeader((String)header.getKey(), (String)header.getValue());
        }
        Utils.stream(resource.getInputStream(), externalContext.getResponseOutputStream());
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }
}

