/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.facesviews.ExtensionAction;
import org.omnifaces.facesviews.FacesServletDispatchMethod;
import org.omnifaces.facesviews.PathAction;
import org.omnifaces.facesviews.ViewHandlerMode;
import org.omnifaces.util.Faces;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

public final class FacesViews {
    public static final String WEB_INF_VIEWS = "/WEB-INF/faces-views/";
    public static final String FACES_VIEWS_ENABLED_PARAM_NAME = "org.omnifaces.FACES_VIEWS_ENABLED";
    public static final String FACES_VIEWS_SCAN_PATHS_PARAM_NAME = "org.omnifaces.FACES_VIEWS_SCAN_PATHS";
    public static final String FACES_VIEWS_SCANNED_VIEWS_EXTENSIONLESS_PARAM_NAME = "org.omnifaces.FACES_VIEWS_SCANNED_VIEWS_ALWAYS_EXTENSIONLESS";
    public static final String FACES_VIEWS_EXTENSION_ACTION_PARAM_NAME = "org.omnifaces.FACES_VIEWS_EXTENSION_ACTION";
    public static final String FACES_VIEWS_PATH_ACTION_PARAM_NAME = "org.omnifaces.FACES_VIEWS_PATH_ACTION";
    public static final String FACES_VIEWS_DISPATCH_METHOD_PARAM_NAME = "org.omnifaces.FACES_VIEWS_DISPATCH_METHOD";
    public static final String FACES_VIEWS_FILTER_AFTER_DECLARED_FILTERS_PARAM_NAME = "org.omnifaces.FACES_VIEWS_FILTER_AFTER_DECLARED_FILTERS";
    public static final String FACES_VIEWS_VIEW_HANDLER_MODE_PARAM_NAME = "org.omnifaces.FACES_VIEWS_VIEW_HANDLER_MODE";
    public static final String SCAN_PATHS = "org.omnifaces.facesviews.scanpaths";
    public static final String PUBLIC_SCAN_PATHS = "org.omnifaces.facesviews.public.scanpaths";
    public static final String SCANNED_VIEWS_EXTENSIONLESS = "org.omnifaces.facesviews.scannedviewsextensionless";
    public static final String FACES_SERVLET_EXTENSIONS = "org.omnifaces.facesviews.facesservletextensions";
    public static final String FACES_VIEWS_RESOURCES = "org.omnifaces.facesviews";
    public static final String FACES_VIEWS_REVERSE_RESOURCES = "org.omnifaces.facesviews.reverse.resources";
    public static final String FACES_VIEWS_RESOURCES_EXTENSIONS = "org.omnifaces.facesviews.extensions";
    public static final String FACES_VIEWS_ORIGINAL_SERVLET_PATH = "org.omnifaces.facesviews.original.servlet_path";

    private FacesViews() {
    }

    public static void scanViewsFromRootPaths(ServletContext servletContext, Map<String, String> collectedViews, Set<String> collectedExtensions) {
        for (String rootPath : FacesViews.getRootPaths(servletContext)) {
            String extensionToScan = null;
            if (rootPath.contains("*")) {
                String[] pathAndExtension = rootPath.split(Pattern.quote("*"));
                rootPath = pathAndExtension[0];
                extensionToScan = pathAndExtension[1];
            }
            rootPath = FacesViews.normalizeRootPath(rootPath);
            FacesViews.scanViews(servletContext, rootPath, servletContext.getResourcePaths(rootPath), collectedViews, extensionToScan, collectedExtensions);
        }
    }

    public static Set<String> getRootPaths(ServletContext servletContext) {
        HashSet<String> rootPaths = (HashSet<String>)servletContext.getAttribute(SCAN_PATHS);
        if (rootPaths == null) {
            rootPaths = new HashSet<String>(Utils.csvToList(servletContext.getInitParameter(FACES_VIEWS_SCAN_PATHS_PARAM_NAME)));
            rootPaths.add(WEB_INF_VIEWS);
            servletContext.setAttribute(SCAN_PATHS, Collections.unmodifiableSet(rootPaths));
        }
        return rootPaths;
    }

    public static Set<String> getPublicRootPaths(ServletContext servletContext) {
        HashSet<String> publicRootPaths = (HashSet<String>)servletContext.getAttribute(PUBLIC_SCAN_PATHS);
        if (publicRootPaths == null) {
            Set<String> rootPaths = FacesViews.getRootPaths(servletContext);
            publicRootPaths = new HashSet<String>();
            for (String rootPath : rootPaths) {
                if (rootPath.contains("*")) {
                    String[] pathAndExtension = rootPath.split(Pattern.quote("*"));
                    rootPath = pathAndExtension[0];
                }
                if ("/".equals(rootPath = FacesViews.normalizeRootPath(rootPath)) || Utils.startsWithOneOf(rootPath, "/WEB-INF/", "/META-INF/")) continue;
                publicRootPaths.add(rootPath);
            }
            servletContext.setAttribute(PUBLIC_SCAN_PATHS, Collections.unmodifiableSet(publicRootPaths));
        }
        return publicRootPaths;
    }

    public static String normalizeRootPath(String rootPath) {
        String normalizedPath = rootPath;
        if (!normalizedPath.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        if (!normalizedPath.endsWith("/")) {
            normalizedPath = normalizedPath + "/";
        }
        return normalizedPath;
    }

    public static boolean isResourceInPublicPath(ServletContext servletContext, String resource) {
        Set<String> publicPaths = FacesViews.getPublicRootPaths(servletContext);
        for (String path : publicPaths) {
            if (!resource.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public static ExtensionAction getExtensionAction(ServletContext servletContext) {
        String extensionActionString = servletContext.getInitParameter(FACES_VIEWS_EXTENSION_ACTION_PARAM_NAME);
        if (Utils.isEmpty(extensionActionString)) {
            return ExtensionAction.REDIRECT_TO_EXTENSIONLESS;
        }
        try {
            return ExtensionAction.valueOf(extensionActionString.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Value '%s' is not valid for context parameter for '%s'", extensionActionString, FACES_VIEWS_EXTENSION_ACTION_PARAM_NAME));
        }
    }

    public static PathAction getPathAction(ServletContext servletContext) {
        String pathActionString = servletContext.getInitParameter(FACES_VIEWS_PATH_ACTION_PARAM_NAME);
        if (Utils.isEmpty(pathActionString)) {
            return PathAction.SEND_404;
        }
        try {
            return PathAction.valueOf(pathActionString.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Value '%s' is not valid for context parameter for '%s'", pathActionString, FACES_VIEWS_PATH_ACTION_PARAM_NAME));
        }
    }

    public static FacesServletDispatchMethod getFacesServletDispatchMethod(ServletContext servletContext) {
        String dispatchMethodString = servletContext.getInitParameter(FACES_VIEWS_DISPATCH_METHOD_PARAM_NAME);
        if (Utils.isEmpty(dispatchMethodString)) {
            return FacesServletDispatchMethod.DO_FILTER;
        }
        try {
            return FacesServletDispatchMethod.valueOf(dispatchMethodString.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Value '%s' is not valid for context parameter for '%s'", dispatchMethodString, FACES_VIEWS_DISPATCH_METHOD_PARAM_NAME));
        }
    }

    public static ViewHandlerMode getViewHandlerMode(FacesContext context) {
        return FacesViews.getViewHandlerMode((ServletContext)context.getExternalContext().getContext());
    }

    public static ViewHandlerMode getViewHandlerMode(ServletContext servletContext) {
        String viewHandlerModeString = servletContext.getInitParameter(FACES_VIEWS_VIEW_HANDLER_MODE_PARAM_NAME);
        if (Utils.isEmpty(viewHandlerModeString)) {
            return ViewHandlerMode.STRIP_EXTENSION_FROM_PARENT;
        }
        try {
            return ViewHandlerMode.valueOf(viewHandlerModeString.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Value '%s' is not valid for context parameter for '%s'", viewHandlerModeString, FACES_VIEWS_VIEW_HANDLER_MODE_PARAM_NAME));
        }
    }

    public static boolean isFilterAfterDeclaredFilters(ServletContext servletContext) {
        String filterAfterDeclaredFilters = servletContext.getInitParameter(FACES_VIEWS_FILTER_AFTER_DECLARED_FILTERS_PARAM_NAME);
        if (filterAfterDeclaredFilters == null) {
            return true;
        }
        return Boolean.valueOf(filterAfterDeclaredFilters);
    }

    public static Boolean isScannedViewsAlwaysExtensionless(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Boolean scannedViewsExtensionless = (Boolean)applicationMap.get(SCANNED_VIEWS_EXTENSIONLESS);
        if (scannedViewsExtensionless == null) {
            scannedViewsExtensionless = externalContext.getInitParameter(FACES_VIEWS_SCANNED_VIEWS_EXTENSIONLESS_PARAM_NAME) == null ? Boolean.valueOf(true) : Boolean.valueOf(externalContext.getInitParameter(FACES_VIEWS_SCANNED_VIEWS_EXTENSIONLESS_PARAM_NAME));
            applicationMap.put(SCANNED_VIEWS_EXTENSIONLESS, scannedViewsExtensionless);
        }
        return scannedViewsExtensionless;
    }

    public static void scanViews(ServletContext servletContext, String rootPath, Set<String> resourcePaths, Map<String, String> collectedViews, String extensionToScan, Set<String> collectedExtensions) {
        if (!Utils.isEmpty(resourcePaths)) {
            for (String resourcePath : resourcePaths) {
                if (ResourcePaths.isDirectory(resourcePath)) {
                    if (!FacesViews.canScanDirectory(rootPath, resourcePath)) continue;
                    FacesViews.scanViews(servletContext, rootPath, servletContext.getResourcePaths(resourcePath), collectedViews, extensionToScan, collectedExtensions);
                    continue;
                }
                if (!FacesViews.canScanResource(resourcePath, extensionToScan)) continue;
                String resource = ResourcePaths.stripPrefixPath(rootPath, resourcePath);
                collectedViews.put(resource, resourcePath);
                collectedViews.put(ResourcePaths.stripExtension(resource), resourcePath);
                if (collectedExtensions == null) continue;
                collectedExtensions.add("*" + ResourcePaths.getExtension(resourcePath));
            }
        }
    }

    public static boolean canScanDirectory(String rootPath, String directory) {
        if (!"/".equals(rootPath)) {
            return true;
        }
        return !Utils.startsWithOneOf(directory, "/WEB-INF/", "/META-INF/", "/resources/");
    }

    public static boolean canScanResource(String resource, String extensionToScan) {
        if (extensionToScan == null) {
            return true;
        }
        return resource.endsWith(extensionToScan);
    }

    public static Map<String, String> scanViews(ServletContext servletContext) {
        HashMap<String, String> collectedViews = new HashMap<String, String>();
        FacesViews.scanViewsFromRootPaths(servletContext, collectedViews, null);
        return collectedViews;
    }

    public static void tryScanAndStoreViews(ServletContext context) {
        if (Servlets.getApplicationAttribute(context, FACES_VIEWS_RESOURCES) == null) {
            FacesViews.scanAndStoreViews(context);
        }
    }

    public static Map<String, String> scanAndStoreViews(ServletContext context) {
        Map<String, String> views = FacesViews.scanViews(context);
        if (!views.isEmpty()) {
            context.setAttribute(FACES_VIEWS_RESOURCES, Collections.unmodifiableMap(views));
            context.setAttribute(FACES_VIEWS_REVERSE_RESOURCES, Collections.unmodifiableMap(Utils.reverse(views)));
        }
        return views;
    }

    public static String stripFacesViewsPrefix(String resource) {
        return ResourcePaths.stripPrefixPath(WEB_INF_VIEWS, resource);
    }

    public static String getMappedPath(String path) {
        String facesViewsPath = path;
        Map mappedResources = (Map)Faces.getApplicationAttribute(FACES_VIEWS_RESOURCES);
        if (mappedResources != null && mappedResources.containsKey(path)) {
            facesViewsPath = (String)mappedResources.get(path);
        }
        return facesViewsPath;
    }

    public static void mapFacesServlet(ServletContext servletContext, Set<String> extensions) {
        ServletRegistration facesServletRegistration = Faces.getFacesServletRegistration(servletContext);
        if (facesServletRegistration != null) {
            Collection mappings = facesServletRegistration.getMappings();
            for (String extension : extensions) {
                if (mappings.contains(extension)) continue;
                facesServletRegistration.addMapping(new String[]{extension});
            }
        }
    }

    public static Set<String> getFacesServletExtensions(FacesContext context) {
        return FacesViews.getFacesServletExtensions((ServletContext)context.getExternalContext().getContext());
    }

    public static Set<String> getFacesServletExtensions(ServletContext servletContext) {
        HashSet<String> extensions = (HashSet<String>)servletContext.getAttribute(FACES_SERVLET_EXTENSIONS);
        if (extensions == null) {
            extensions = new HashSet<String>();
            ServletRegistration facesServletRegistration = Faces.getFacesServletRegistration(servletContext);
            if (facesServletRegistration != null) {
                Collection mappings = facesServletRegistration.getMappings();
                for (String mapping : mappings) {
                    if (!mapping.startsWith("*")) continue;
                    extensions.add(mapping.substring(1));
                }
            }
            servletContext.setAttribute(FACES_SERVLET_EXTENSIONS, Collections.unmodifiableSet(extensions));
        }
        return extensions;
    }

    public static String getExtensionlessURLWithQuery(HttpServletRequest request) {
        return FacesViews.getExtensionlessURLWithQuery(request, request.getServletPath());
    }

    public static String getExtensionlessURLWithQuery(HttpServletRequest request, String resource) {
        String queryString = !Utils.isEmpty(request.getQueryString()) ? "?" + request.getQueryString() : "";
        String baseURL = Servlets.getRequestBaseURL(request);
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + ResourcePaths.stripExtension(resource) + queryString;
    }
}

