/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.dashboard.Dashboard;
import org.primefaces.component.dnd.Draggable;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DraggableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Draggable draggable = (Draggable)component;
        String clientId = draggable.getClientId(context);
        UIComponent target = SearchExpressionFacade.resolveComponentWithParentFallback(context, (UIComponent)draggable, draggable.getFor());
        String dashboard = draggable.getDashboard();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Draggable", draggable.resolveWidgetVar(), clientId).attr("target", target.getClientId(context)).attr("cursor", draggable.getCursor()).attr("disabled", draggable.isDisabled(), false).attr("axis", draggable.getAxis(), null).attr("containment", draggable.getContainment(), null).attr("helper", draggable.getHelper(), null).attr("zIndex", draggable.getZindex(), -1).attr("handle", draggable.getHandle(), null).attr("opacity", draggable.getOpacity(), 1.0).attr("stack", draggable.getStack(), null).attr("scope", draggable.getScope(), null);
        if (draggable.isRevert()) {
            wb.attr("revert", "invalid");
        }
        if (draggable.getGrid() != null) {
            wb.append(",grid:[").append(draggable.getGrid()).append("]");
        }
        if (draggable.isSnap()) {
            wb.attr("snap", true).attr("snapTolerance", draggable.getSnapTolerance()).attr("snapMode", draggable.getSnapMode(), null);
        }
        if (dashboard != null) {
            Dashboard db = (Dashboard)SearchExpressionFacade.resolveComponent(context, (UIComponent)draggable, dashboard);
            String selector = ComponentUtils.escapeJQueryId(db.getClientId(context)) + " .ui-dashboard-column";
            wb.attr("connectToSortable", selector);
        }
        wb.finish();
    }
}

