/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.row.Row;
import org.primefaces.context.RequestContext;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFeature
implements DataTableFeature {
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    private static final String STARTS_WITH_MATCH_MODE = "startsWith";
    private static final String ENDS_WITH_MATCH_MODE = "endsWith";
    private static final String CONTAINS_MATCH_MODE = "contains";
    private static final String EXACT_MATCH_MODE = "exact";
    static final Map<String, FilterConstraint> FILTER_CONSTRAINTS = new HashMap<String, FilterConstraint>();

    private boolean isFilterRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
        List<FilterMeta> filterMetadata = this.createFilterMetaData(context, table);
        Map<String, String> filterParameterMap = this.populateFilterParameterMap(context, table, filterMetadata, globalFilterParam);
        table.setFilters(filterParameterMap);
        table.setFilterMetadata(filterMetadata);
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        this.updateFilteredValue(context, table, null);
        table.setFirst(0);
        table.setRowIndex(-1);
        if (table.isLazy()) {
            table.loadLazyData();
        } else {
            String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
            this.filter(context, table, table.getFilterMetadata(), globalFilterParam);
            Object sortBy = table.getSortBy();
            if (sortBy != null) {
                SortFeature sortFeature = (SortFeature)table.getFeature(DataTableFeatureKey.SORT);
                if (table.isMultiSort()) {
                    sortFeature.multiSort(context, table);
                } else {
                    sortFeature.singleSort(context, table);
                }
            }
        }
        renderer.encodeTbody(context, table, true);
    }

    private void filter(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, String globalFilterParam) {
        RequestContext requestContext;
        Map params = context.getExternalContext().getRequestParameterMap();
        ArrayList<Object> filteredData = new ArrayList<Object>();
        boolean hasGlobalFilter = params.containsKey(globalFilterParam);
        String globalFilter = hasGlobalFilter ? ((String)params.get(globalFilterParam)).toLowerCase() : null;
        String var = table.getVar();
        ELContext elContext = context.getELContext();
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            boolean localMatch = true;
            boolean globalMatch = false;
            for (FilterMeta filterMeta : filterMetadata) {
                String filterParam = filterMeta.getFilterParam();
                UIColumn column = filterMeta.getColumn();
                ValueExpression filterByVE = filterMeta.getFilterByVE();
                String filterParamValue = params.containsKey(filterParam) ? ((String)params.get(filterParam)).toLowerCase() : null;
                String columnValue = String.valueOf(filterByVE.getValue(elContext));
                FilterConstraint filterConstraint = this.getFilterConstraint(column);
                if (hasGlobalFilter && !globalMatch && columnValue != null && columnValue.toLowerCase().contains(globalFilter)) {
                    globalMatch = true;
                }
                if (ComponentUtils.isValueBlank(filterParamValue)) {
                    localMatch = true;
                    continue;
                }
                if (columnValue != null && filterConstraint.applies(columnValue.toLowerCase(), filterParamValue)) continue;
                localMatch = false;
                break;
            }
            boolean matches = localMatch;
            if (hasGlobalFilter) {
                boolean bl = matches = localMatch && globalMatch;
            }
            if (!matches) continue;
            filteredData.add(table.getRowData());
        }
        if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
            requestContext.addCallbackParam("totalRecords", filteredData.size());
        }
        this.updateFilteredValue(context, table, filteredData);
        table.setRowIndex(-1);
    }

    public void updateFilteredValue(FacesContext context, DataTable table, List<?> value) {
        table.setSelectableDataModelWrapper(null);
        ValueExpression ve = table.getValueExpression("filteredValue");
        if (ve != null) {
            ve.setValue(context.getELContext(), value);
        } else {
            if (value != null) {
                logger.log(Level.WARNING, "DataTable {0} has filtering enabled but no filteredValue model reference is defined, for backward compatibility falling back to page viewstate method to keep filteredValue. It is highly suggested to use filtering with a filteredValue model reference as viewstate method is deprecated and will be removed in future.", new Object[]{table.getClientId(context)});
            }
            table.setFilteredValue(value);
        }
    }

    public Map<String, String> populateFilterParameterMap(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, String globalFilterParam) {
        Map params = context.getExternalContext().getRequestParameterMap();
        HashMap<String, String> filterParameterMap = new HashMap<String, String>();
        for (FilterMeta filterMeta : filterMetadata) {
            String filterParam = filterMeta.getFilterParam();
            UIColumn column = filterMeta.getColumn();
            String filterValue = (String)params.get(filterParam);
            if (ComponentUtils.isValueBlank(filterValue)) continue;
            if (column instanceof DynamicColumn) {
                ((DynamicColumn)column).applyStatelessModel();
            }
            String filterField = String.valueOf(column.getFilterBy());
            filterParameterMap.put(filterField, filterValue);
        }
        if (params.containsKey(globalFilterParam)) {
            filterParameterMap.put("globalFilter", (String)params.get(globalFilterParam));
        }
        return filterParameterMap;
    }

    private List<FilterMeta> createFilterMetaData(FacesContext context, DataTable table) {
        ArrayList<FilterMeta> filterMetadata = new ArrayList<FilterMeta>();
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        String var = table.getVar();
        ColumnGroup group = this.getColumnGroup(table, "header");
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                Row headerRow = (Row)child;
                if (!headerRow.isRendered()) continue;
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    Object filterBy;
                    Column column = (Column)headerRowChild;
                    if (!column.isRendered() || (filterBy = column.getFilterBy()) == null) continue;
                    String filterId = column.getClientId(context) + separator + "filter";
                    filterMetadata.add(new FilterMeta(column, this.createFilterByVE(context, var, filterBy), filterId));
                }
            }
        } else {
            for (UIColumn column : table.getColumns()) {
                if (column instanceof Column && column.getFilterBy() != null) {
                    String filterId = column.getClientId(context) + separator + "filter";
                    filterMetadata.add(new FilterMeta(column, this.createFilterByVE(context, var, column.getFilterBy()), filterId));
                    continue;
                }
                if (!(column instanceof DynamicColumn) || column.getValueExpression("filterBy") == null) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyStatelessModel();
                String filterId = dynamicColumn.getContainerClientId(context) + separator + "filter";
                filterMetadata.add(new FilterMeta(column, this.createFilterByVE(context, var, column.getFilterBy()), filterId));
            }
        }
        return filterMetadata;
    }

    private ColumnGroup getColumnGroup(DataTable table, String target) {
        for (UIComponent child : table.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public FilterConstraint getFilterConstraint(UIColumn column) {
        String filterMatchMode = column.getFilterMatchMode();
        FilterConstraint filterConstraint = FILTER_CONSTRAINTS.get(filterMatchMode);
        if (filterConstraint == null) {
            throw new FacesException("Illegal filter match mode:" + filterMatchMode);
        }
        return filterConstraint;
    }

    private ValueExpression createFilterByVE(FacesContext context, String var, Object filterBy) {
        ELContext elContext = context.getELContext();
        return context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + var + "." + filterBy + "}", Object.class);
    }

    static {
        FILTER_CONSTRAINTS.put(STARTS_WITH_MATCH_MODE, new StartsWithFilterConstraint());
        FILTER_CONSTRAINTS.put(ENDS_WITH_MATCH_MODE, new EndsWithFilterConstraint());
        FILTER_CONSTRAINTS.put(CONTAINS_MATCH_MODE, new ContainsFilterConstraint());
        FILTER_CONSTRAINTS.put(EXACT_MATCH_MODE, new ExactFilterConstraint());
    }

    private class FilterMeta {
        private UIColumn column;
        private ValueExpression filterByVE;
        private String filterParam;

        public FilterMeta(UIColumn column, ValueExpression filterByVE, String filterParam) {
            this.column = column;
            this.filterByVE = filterByVE;
            this.filterParam = filterParam;
        }

        public UIColumn getColumn() {
            return this.column;
        }

        public ValueExpression getFilterByVE() {
            return this.filterByVE;
        }

        public String getFilterParam() {
            return this.filterParam;
        }
    }
}

