/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.util.MapWrapper;

public class ImportConstants
extends TagHandler {
    private static Map<String, Map<String, Object>> CONSTANTS_CACHE = new HashMap<String, Map<String, Object>>();
    private static final String ERROR_INVALID_VAR = "The 'var' attribute may not be an EL expression.";
    private static final String ERROR_MISSING_CLASS = "Cannot find type '%s' in classpath.";
    private static final String ERROR_FIELD_ACCESS = "Cannot access constant field '%s' of type '%s'.";
    private static final String ERROR_INVALID_CONSTANT = "Type '%s' does not have the constant '%s'.";
    private String var;
    private TagAttribute type;

    public ImportConstants(TagConfig config) {
        super(config);
        TagAttribute var = this.getAttribute("var");
        if (var != null) {
            if (var.isLiteral()) {
                this.var = var.getValue();
            } else {
                throw new IllegalArgumentException(ERROR_INVALID_VAR);
            }
        }
        this.type = this.getRequiredAttribute("type");
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        String type = this.type.getValue(context);
        Map<String, Object> constants = CONSTANTS_CACHE.get(type);
        if (constants == null) {
            constants = ImportConstants.collectConstants(type);
            CONSTANTS_CACHE.put(type, constants);
        }
        context.setAttribute(this.var != null ? this.var : type.substring(type.lastIndexOf(46) + 1), constants);
    }

    private static Map<String, Object> collectConstants(String type) {
        LinkedHashMap<String, Object> constants = new LinkedHashMap<String, Object>();
        for (Field field : ImportConstants.toClass(type).getFields()) {
            if (!ImportConstants.isPublicStaticFinal(field)) continue;
            try {
                constants.put(field.getName(), field.get(null));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(ERROR_FIELD_ACCESS, type, field.getName()), e);
            }
        }
        return new ConstantsMap(constants, type);
    }

    private static Class<?> toClass(String type) {
        try {
            return Class.forName(type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            int i = type.lastIndexOf(46);
            if (i > 0) {
                try {
                    return Class.forName(type.substring(0, i) + '$' + type.substring(i + 1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(String.format(ERROR_MISSING_CLASS, type), e);
        }
    }

    private static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    private static class ConstantsMap
    extends MapWrapper<String, Object> {
        private String type;

        public ConstantsMap(Map<String, Object> map, String type) {
            super(Collections.unmodifiableMap(map));
            this.type = type;
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException(String.format(ImportConstants.ERROR_INVALID_CONSTANT, this.type, key));
            }
            return super.get(key);
        }
    }
}

